/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSVOLUME_H
#define RDSVOLUME_H

#include <ClientProxy>
#include <QxtPimpl>
#include <rdsglobal.h>

class RdsVolumePrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RDS_CLIENT_EXPORT RdsVolume : public QtRpc::ClientProxy
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsVolume);
	QTRPC_CLIENTPROXY_PIMPL(RdsVolume);
public:
	RdsVolume(QObject *parent = 0);
	RdsVolume(const RdsVolume &mgr);
	~RdsVolume();

	RdsVolume &operator=(const RdsVolume &mgr);

signals:
	ReturnValue initialize(); // This wipes out the fs and rebuilds it...
	ReturnValue initialize(QObject *object, const char *slot);
	ReturnValue isAdded() const; // if it's registered to RDS or not
	ReturnValue storageDevice();
	ReturnValue mountPoint() const;
	ReturnValue mount();
	ReturnValue mount(const QString &path, const QStringList &options);
	ReturnValue unmount();
	ReturnValue isMounted() const;
	ReturnValue path() const;
	ReturnValue size() const;
	ReturnValue freeSpace() const;
	ReturnValue supportsNtAcls() const;
	ReturnValue fsType() const;
	ReturnValue type() const; // type of volume class
	ReturnValue satus() const; // generic status (Normal, Unused, Warning, Error)
	ReturnValue statusText() const; // simple status description
	ReturnValue statusDetails() const; // detailed status report
	ReturnValue name();
	ReturnValue setName(const QString &name); // we need to move the mount point if this is changed while mounted
	ReturnValue id() const; // unique device ID
	ReturnValue mkfs(const QString &type, const QStringList &options, quint64 blocks);
	ReturnValue serialNumber() const;
	ReturnValue model() const;
	ReturnValue isEjectable() const;
	ReturnValue eject();
};

#endif
