/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef ACEMODEL_H
#define ACEMODEL_H

#include <QAbstractItemModel>
#include <RdsNtAcl>

/**
	@author Brendan Powers <brendan@resara.com>
*/
class AceModel : public QAbstractItemModel
{
	Q_OBJECT
public:
	enum Flag
	{
		None = 0,
		ReadData = RdsAce::CreateChild,
		ReadAttributes = RdsAce::ListObject,
		ReadExtendedAttributes = RdsAce::SelfWrite,
		ReadPermissions = RdsAce::ReadControl,
		Read = ReadData | ReadAttributes | ReadExtendedAttributes | ReadPermissions,
		CreateFile = RdsAce::DeleteChild,
		CreateFolder = RdsAce::ListChildren,
		WriteAttributes = RdsAce::ControlAccess,
		WriteExtendedAttributes = RdsAce::ReadProperty,
		Delete = RdsAce::Delete,
		Write = CreateFile | CreateFolder | WriteAttributes | WriteExtendedAttributes,
		DeleteTree = RdsAce::DeleteTree,
		TakeOwnership = RdsAce::WriteOwner,
		ChangePermissions = RdsAce::WriteDac,
		Special = 1 << 26,
		List = (int)RdsAce::WriteProperty,
		ReadAndExec = Read | List | 1 << 25,
		Modify = List | Read | Write | Delete,
		FullControl = Modify | DeleteTree | TakeOwnership | ChangePermissions,
		FileInherit = RdsAce::FileInherit << 27,
		FolderInherit = RdsAce::FolderInherit << 27,
		InheritOnly = RdsAce::InheritOnly << 27,
		NoPropogate = RdsAce::NoPropogate << 27,
		InheritFlags = FileInherit | FolderInherit | InheritOnly | NoPropogate,
	};
	Q_DECLARE_FLAGS(Flags, Flag);

	enum DisplayFlag
	{
		Exclusive = 1 << 0,
		AllowOnly = 1 << 1
	};

	Q_DECLARE_FLAGS(DisplayFlags, DisplayFlag);

	struct Permission
	{
		QString name;
		Flags flags;
		DisplayFlags display;
		Flags excluded;

		Permission *parent;
		QList<Permission *> children;
	};

	AceModel(QObject *parent = 0);
	~AceModel();

	int rowCount(const QModelIndex &parent = QModelIndex()) const;
	int columnCount(const QModelIndex &parent = QModelIndex()) const;
	QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
	QModelIndex parent(const QModelIndex &index) const;
	Qt::ItemFlags flags(const QModelIndex &index) const;
	QVariant data(const QModelIndex &index, int role) const;
	bool setData(const QModelIndex &index, const QVariant &value, int role);
	QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
	void setFlags(RdsAce::AccessFlags allow, RdsAce::AccessFlags deny, RdsAce::AccessFlags inheritedallow,
	              RdsAce::AccessFlags inheriteddeny, bool allowspecial, bool denyspecial, RdsAce::Flags inheritflags =
	                  RdsAce::InheritOnly | RdsAce::NoPropogate | RdsAce::FileInherit | RdsAce::ContainerInherit | RdsAce::FolderInherit);

signals:
	void flagsChanged(RdsAce::AccessFlags allow, RdsAce::AccessFlags deny, RdsAce::Flags flags, RdsAce::Flags lastflags);

public slots:
	void setAdvanced(bool advanced);

private:
	Permission *createPermission(QString name, Flags flags, Permission *parent = NULL, DisplayFlags display = 0, Flags excluded = 0);
	QList<Permission *> removePermissions(Permission *perm = NULL);
	void updateAll(const QModelIndex &index = QModelIndex());
	void checkExcluded(Permission *perm = NULL);
	bool _advanced;
	QList<Permission *> _permissions;
	Flags _allowflags;
	Flags _denyflags;
	Flags _inheritedallowflags;
	Flags _inheriteddenyflags;
	Flags _lastinheritence;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(AceModel::Flags);
Q_DECLARE_OPERATORS_FOR_FLAGS(AceModel::DisplayFlags);

#endif
