/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDSHAREDIALOG_H
#define ADDSHAREDIALOG_H

#include <QDialog>
#include "ui_addsharedialog.h"
#include <ReturnValue>
#include <RdsFileManager>

class AddShareDialog : public QDialog, private Ui::AddShareDialog
{
	Q_OBJECT

public:
	AddShareDialog(QWidget* parent = 0, Qt::WFlags fl = 0);
	AddShareDialog(QString path, QWidget* parent = 0, Qt::WFlags fl = 0);
	~AddShareDialog();

	static ReturnValue checkValidVolume(QString path);
	
protected slots:
	void accept();
	void on_NameEdit_textEdited(QString text);
	void on_BrowseButton_clicked();

private:
	ReturnValue setPermissions(QString path, RdsFileManager &filemgr);
	static QString _defaultpath;
	QString _lasttxt;
	
};

#endif

