/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "checkwidget.h"
#include <QDebug>
#include "config.h"


CheckWidget::CheckWidget(QWidget* parent, Qt::WFlags fl)
		: QWidget(parent, fl), Ui::CheckWidget()
{
	setupUi(this);
	QObject::connect(List, SIGNAL(clicked(QModelIndex)), this, SIGNAL(changed()));
}

CheckWidget::~CheckWidget()
{
}


QStringList CheckWidget::list() const
{
	QStringList tmp;
	for(int i = 0; i < List->count(); i++)
	{
		tmp << List->item(i)->text();
	}
	
	return(tmp);
}

void CheckWidget::setList(const QStringList& newlist)
{
	List->clear();
	
	foreach(QString text, newlist)
	{
		QListWidgetItem *item = new QListWidgetItem(text, List);
		item->setFlags(item->flags() | Qt::ItemIsUserCheckable);
		item->setCheckState(Qt::Unchecked);
	}
}

QStringList CheckWidget::checked() const
{
	QStringList tmp;
	for(int i = 0; i < List->count(); i++)
	{
		if(List->item(i)->checkState() == Qt::Checked)
		{
			tmp << List->item(i)->text();
		}
	}
	
	return(tmp);
}

void CheckWidget::setChecked(const QStringList& newchecked)
{
	for(int i = 0; i < List->count(); i++)
	{
		if(newchecked.contains(List->item(i)->text()))
		{
			List->item(i)->setCheckState(Qt::Checked);
		}
		else
		{
			List->item(i)->setCheckState(Qt::Unchecked);
		}
	}
}
