/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "foldereditwidget.h"
#include <RdsEntityManager>
#include <QMessageBox>
#include <QDebug>
#include <RdsShare>
#include <RdsUtils>
#include <RdsDaemonManager>
#include <RdsFileManager>

FolderEditWidget::FolderEditWidget(RdsEntityManager *manager, QWidget* parent)
		: RdsEntityWidget(manager, parent), Ui::FolderEditWidget()
{
	setupUi(this);
	setApplyButton(ApplyButton);
	setDiscardButton(DiscardButton);

	addWidget("acl", AclWidget, "acl", SIGNAL(changed()), NoMulti, QStringList());

	QObject::connect(manager, SIGNAL(entityRenamed(QString, QString)), this, SLOT(entityRenamed(QString, QString)));
}

FolderEditWidget::~FolderEditWidget()
{
}

void FolderEditWidget::entityRenamed(QString oldid, QString newid)
{
	if (oldid != input()) return;

	QStringList outlist = outputs();
	for (int i = 0; i < outlist.size(); i++)
	{
		if (outlist[i] == input()) outlist[i] = newid;
	}

	setInput(newid);
	setOutputs(outlist);

	//setField("name", newid);
}

#define GET_DATA(name,function) ret = function; \
	if(ret.isError() && !ret.errString().endsWith("attribute does not exist")\
	        && (ret.errString() != "Operation not supported")) err = ret; \
	fields[name] = ret

ReturnValue FolderEditWidget::getData()
{
	QVariantMap fields;

	if (input() == "") return(ReturnValue(1, "Invalid Folder"));

	ReturnValue err = true;

	RdsFileManager manager;
	ReturnValue ret = manager.init();
	if (ret.isError()) return(ret);

	AclWidget->setPath(input());
	ret = manager.ntPermissions(input());
	if (ret.isError())
	{
		AclWidget->setEnabled(false);
		setFieldEnabled("acl", false);
		fields["acl"] = QVariant::fromValue(RdsNtAcl());
	}
	else
	{
		fields["acl"] = ret;
	}

	if (err.isError())
	{
		QMessageBox msg(QMessageBox::Warning, "Error", "There was an error opening this folder: " + ret.errString(), QMessageBox::Ok);
		QAbstractButton *editbutton = msg.addButton("Edit Anyway", QMessageBox::RejectRole);
		msg.exec();
		if (msg.clickedButton() == editbutton)
		{
			if (QMessageBox::warning(this, "Warning", "Editing in this state may be dangerous. Continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
			{
				return(fields);
			}
		}
		return(err);
	}

	return(fields);
}

#define SET_FIELD(field,function) if (name == field) \
	{ \
		ret = function; \
		if (ret.isError()) err = ret; \
	}

#define SET_FIELD_STRING(field,function) \
	SET_FIELD(field,share.function(value.toString()));
#define SET_FIELD_BOOL(field,function) \
	SET_FIELD(field,share.function(value.toBool()));

bool FolderEditWidget::setData(QString id, QVariantMap fields)
{
	ReturnValue err = true;
	ReturnValue ret;

	foreach(QString name, fields.keys())
	{
		QVariant value = fields[name];

		RdsFileManager fmgr;
		ret = fmgr.init();
		if (ret.isError()) qWarning() << "Failed to get file manager:" << ret;


		if (name == "acl")
		{
			RdsNtAcl acl = value.value<RdsNtAcl>();
			ret = fmgr.setNtPermissions(input(), acl);
			if (ret.isError())
			{
				err = ret;
			}
		}
	}

	if (err.isError())
	{
		qWarning() << "Failed to save share:" << id << err.errString();
		return(false);
	}
	else return(true);
}

void FolderEditWidget::entityUpdated(QString id)
{
	if (id != input()) return;

	if (unsavedChanges())
	{
		if (QMessageBox::question(this, "Folder Changed",
		                          "Another user has made changes to the item you are editing. Would you like to overwrite your changes?",
		                          QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
		{
			RdsEntityWidget::entityUpdated(id);
		}
	}
	else
	{
		RdsEntityWidget::entityUpdated(id);
	}
}
