/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#ifndef NETWORKWIDGET_H
#define NETWORKWIDGET_H

#include <QWidget>
#include "ui_networkwidget.h"
#include <ReturnValue>
#include <rdsprovisionator.h>

class NetworkWidget : public QWidget, private Ui::NetworkWidget
{
	Q_OBJECT

public:
	NetworkWidget(QWidget* parent = 0, Qt::WFlags fl = 0);
	~NetworkWidget();

protected slots:
	void load();
	void loadReturned(uint id, ReturnValue ret);
	void save();
	void on_ApplyButton_clicked();
	void on_DiscardButton_clicked();
	void dataChanged();


private:
	bool validTest(QLineEdit *edit, QString error, QRegExpValidator *validator);
	RdsProvisionator *_provisionator;
	QVariantMap _settings;
	QVariantMap _newsettings;
	QString _interface;
	QString _ip;
	QString _netmask;
	QString _gateway;
	QString _dns1;
	QString _dns2;
};

#endif

