/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/


#include "oueditwidget.h"
#include <RdsOrganizationalUnit>
#include <QMessageBox>
#include <QDebug>
#include <RdsEntityManager>

OuEditWidget::OuEditWidget(RdsEntityManager *manager, QWidget* parent)
		: RdsEntityWidget(manager, parent), Ui::OuEditWidget()
{
	setupUi(this);
	setApplyButton(ApplyButton);
	setDiscardButton(DiscardButton);
	
	//General
	addWidget("ou",Name,NoMulti);
	addWidget("description",Description,NoMulti);
	
	QObject::connect(manager, SIGNAL(entityRenamed(QString, QString)), this, SLOT(entityRenamed(QString, QString)));
}

OuEditWidget::~OuEditWidget()
{
}

#define GET_DATA(name,function) ret = function; \
	if(ret.isError() && !ret.errString().endsWith("attribute does not exist")) err = ret; \
	fields[name] = ret

ReturnValue OuEditWidget::getData()
{
	QVariantMap fields;
	
	if (input() == "") return(ReturnValue(1, "Invalid OU"));
	
	RdsOrganizationalUnit ou(input());
	
	ReturnValue err = true;
	ReturnValue ret;
	
	GET_DATA("ou",ou.ou());
	GET_DATA("description",ou.description());
	
	if (err.isError())
	{
		QMessageBox msg(QMessageBox::Warning, "Error", "There was an error opening this OU: " + ret.errString(), QMessageBox::Ok);
		QAbstractButton *editbutton = msg.addButton("Edit Anyway", QMessageBox::RejectRole);
		msg.exec();
		if (msg.clickedButton() == editbutton)
		{
			if (QMessageBox::warning(this, "Warning", "Editing an OU in this state may be dangerous. Continue?", QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
			{
				return(fields);
			}
		}
		return(err);
	}
	

	return(fields);
}

#define SET_FIELD(field,function) if (name == field) \
{ \
		ret = function; \
		if (ret.isError()) err = ret; \
}

#define SET_FIELD_STRING(field,function) \
	SET_FIELD(field,ou.function(value.toString()));

bool OuEditWidget::setData(QString id, QVariantMap fields)
{
	RdsOrganizationalUnit ou(id);

	ReturnValue err = true;
	ReturnValue ret;
	
	foreach(QString name, fields.keys())
	{
		QVariant value = fields[name];
		
		SET_FIELD_STRING("description",setDescription);
		
		if (name == "ou")
		{
		//qDebug() << "setting cn" << value;
			ret = ou.setOu(value.toString());
			if (ret.isError())
			{
				err = ret;
			}
			else
			{
				QString dn = ret.toString();

				QStringList outlist = outputs();
				for (int i = 0; i < outlist.size(); i++)
				{
					if (outlist[i] == id) outlist[i] = dn;
				}

				setInput(dn);
				setOutputs(outlist);

				manager()->renameEntity(id, dn);
			}
		}
	}
	
	if (err.isError())
	{
		qWarning() << "Failed to save ou:" << id << err.errString();
		return(false);
	}
	else return(true);
}

void OuEditWidget::entityUpdated(QString id)
{
	if (id != input()) return;

	if (unsavedChanges())
	{
		if (QMessageBox::question(this, "OU Changed",
		                          "Another user has made changes to the item you are editing. Would you like to overwrite your changes?",
		                          QMessageBox::Yes | QMessageBox::No, QMessageBox::No) == QMessageBox::Yes)
		{
			RdsEntityWidget::entityUpdated(id);
		}
	}
	else
	{
		RdsEntityWidget::entityUpdated(id);
	}
}

void OuEditWidget::entityRenamed(QString oldid, QString newid)
{
	if (oldid != input()) return;

	RdsOrganizationalUnit unit(newid);
	ReturnValue ret = unit.ou();
	if (ret.isError()) return;

	QString ou = ret.toString();

	QStringList outlist = outputs();
	for (int i = 0; i < outlist.size(); i++)
	{
		if (outlist[i] == input()) outlist[i] = newid;
	}

	setInput(newid);
	setOutputs(outlist);

	setField("ou", ou);
}
