/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSENTITYMODEL_H
#define RDSENTITYMODEL_H

#include <QAbstractItemModel>
#include <QxtPimpl>
#include <RdsEntityManager>
#include <RdsEntity>
#include <RdsEntityManager>
#include <QStringList>

class QTreeView;
class RdsEntitySortModel;
class RdsEntityModelPrivate;
class RdsEntityModelCachePrivate;
/**
	@author Brendan Powers <brendan@resara.com>
*/
class RdsEntityModel : public QAbstractItemModel
{
	Q_OBJECT
	QXT_DECLARE_PRIVATE(RdsEntityModel);
public:
	class Cache
	{
		friend class RdsEntityModelCachePrivate;
		QxtPrivateInterface<Cache, RdsEntityModelCachePrivate> qxt_d;
	public:
		Cache();
                Cache(Cache *parent);
		Cache(const RdsEntity &entity, Cache *parent = NULL);

		Cache &operator =(const RdsEntity &object);
		QString name() const;
		QString id() const;
		QString type() const;
		bool visible() const;
		QVariantMap &metadata();
		QList<Cache *> &children();
		Cache *parent();
		bool isGroup();
		bool hasMore();
		void setHasMore(bool more);
		void setName(QString name);
	};

	RdsEntityModel(RdsEntityManager *manager, int columns, QObject *parent = 0);
	~RdsEntityModel();


	int rowCount(const QModelIndex &parent = QModelIndex()) const;
	QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
	QModelIndex parent(const QModelIndex &index) const;
	Qt::ItemFlags flags(const QModelIndex &index) const;
	virtual Qt::ItemFlags flags(const QModelIndex &index, Cache *cache) const;
	virtual QVariant data(const QModelIndex &index, int role) const;
	virtual bool setData(const QModelIndex &index, const QVariant &value, int role);
	virtual bool setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache);
	virtual QVariant userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const;
	virtual QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
	virtual QVariant userHeaderData(int section, int role = Qt::DisplayRole) const;
	int columnCount(const QModelIndex &parent = QModelIndex()) const;
	Cache *getCache(const QModelIndex &index) const;
	Cache *getCache(QString dn) const;
	RdsEntityManager *manager();
	bool dropMimeData(const QMimeData * data, Qt::DropAction action, int row, int column, const QModelIndex & parent);
	QMimeData * mimeData(const QModelIndexList & indexes) const;
	QStringList mimeTypes() const;
	virtual void move(Cache *entity, Cache *parent);
	void setupSelection(RdsEntitySortModel *sort, QTreeView *view);
	QString input();
	QStringList outputs();
	void setConstrainSelection(bool constrain);
	bool hasChildren(const QModelIndex &parent) const;
	bool canFetchMore(const QModelIndex &parent) const;
	void fetchMore(const QModelIndex &parent);
	void setCachedPixmap(QString name,const QPixmap &pixmap);
	QPixmap cachedPixmap(QString name) const;
	void expandEntity(QString id);
	void reload();
	QModelIndex indexFromCache(Cache *cache, int column = 0);
	
signals:
	void inputChanged(QString id, QString type);
	void outputsChanged(QStringList outputs);
	void entityUpdateFinished(QString id);
	void entityMetadataUpdateFinished(QString id);
	void loaded();
	
protected slots:
	void entitiesReturned(uint id, ReturnValue ret);
	void entityAdded(QString entity);
        void entityRemoved(QString entity, bool events=true);
	void entityRenamed(QString oldentity, QString newentity);
	void entityUpdated(QString entity);
	void entityMetadataUpdated(QString entity, QVariantMap metadata);
	void editingStarted(QString id);
	void editingStopped(QString id);
	void outputsChanged();
	void dataReceived(uint id, ReturnValue ret);
	void onTimerUpdate();
	void loadEntity(uint id, ReturnValue ret);
	void finishExpanding(QString entity);

protected:
	void loadEntity(RdsEntity entity, Cache *cache);
	void deleteCache(Cache *cache);
	void invalidateIndexes(Cache *cache);

};

#endif
