/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#include <QHash>
#include <RdsEntitySortModel>
#include <QItemSelectionModel>
#include <QStringList>
#include <QHash>
#include <QPixmap>

class RdsEntityModelCachePrivate : public QxtPrivate<RdsEntityModel::Cache>
{
public:
	RdsEntityModelCachePrivate() {}
	
	QString name;
	QString id;
	bool visible;
	QString type;
	QVariantMap metadata;
	QList<RdsEntityModel::Cache *>children;
	RdsEntityModel::Cache *parent;
	bool group;
	bool hasmore;
};

class RdsEntityModelPrivate : public QxtPrivate<RdsEntityModel>
{
public:
	RdsEntityModelPrivate() {}
	
	int columns;
	RdsEntityManager *manager;
	RdsEntityModel::Cache *root;
	QHash<QString, RdsEntityModel::Cache *> idmap;
	QString inputtype;
	QString input;
	QStringList outputs;
	RdsEntitySortModel *sort;
	QItemSelectionModel *selection;
	QTreeView *view;
	bool constrainselection;
	QHash<QString, QPixmap> pixmaps;
	QHash<RdsEntityModel::Cache *,RdsEntityModel::Cache *> loadingindexes;
	QHash<uint, RdsEntityModel::Cache *> loadingcaches;
	int loadingframe;
	QList<QPixmap> loadingframes;
	QHash<int, QString> entitymap;
	QHash<uint, int> asyncmap;
	QList<RdsEntity> entitylist;
	QPixmap editicon;
	QList<QString> editlist;
};
