/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/

#include <QPushButton>
#include <QVariant>
#include <QHash>
#include <QWidget>
#include <RdsEntityManager>

class RdsEntityWidgetPrivate : public QxtPrivate<RdsEntityWidget>
{
public:
	RdsEntityWidgetPrivate() {}
	
	QPushButton *applybutton;
	QPushButton *discardbutton;
	
	struct Field
	{
		QString name;
		QVariant value;
		QString property;
		RdsEntityWidget::Flags flags;
		QVariant def;
		bool enabled;
		QString errtext;
	};
	
	QHash<QString, Field> fields;
	QHash<QString, QObject *> widgets;
	QHash<QObject *, QString> fieldmap;
	QStringList modifiedfields;
	RdsEntityManager *manager;
	QString input;
	QStringList outputs;
};
