/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsfilemodel.h"
#include <QPixmap>
#include <QMessageBox>
#include <RdsShareManager>
#include <RdsShare>
#include "config.h"

RdsFileModel::RdsFileModel(RdsFileManager *manager, QObject *parent)
		: RdsEntityModel(manager, 1, parent)
{
	_manager = manager;
	setCachedPixmap("volume", QPixmap(findRdsIcon("./icons/16x16/hdd_unmount.png")));
	setCachedPixmap("filesystem", QPixmap(findRdsIcon("./icons/16x16/folder_red.png")));
	setCachedPixmap("share", QPixmap(findRdsIcon("./icons/16x16/folder_html.png")));
	setCachedPixmap("folder", QPixmap(findRdsIcon("./icons/16x16/folder.png")));
}


RdsFileModel::~RdsFileModel()
{
}


QVariant RdsFileModel::userData(const QModelIndex &index, int role, RdsEntityModel::Cache *cache) const
{
	Q_UNUSED(index);

	if (role == Qt::DecorationRole)
	{
		return(cachedPixmap(cache->type()));
	}

	return(QVariant());
}

QVariant RdsFileModel::userHeaderData(int section, int role) const
{
	Q_UNUSED(section);
	if (role == Qt::DisplayRole)
	{
		return("Users");
	}

	return(QVariant());
}

Qt::ItemFlags RdsFileModel::flags(const QModelIndex &index, Cache *cache) const
{
	Q_UNUSED(index);
	if (cache->type() == "volume") return(0);
	else if (cache->type() == "filesystem") return(0);
	else 	return(Qt::ItemIsEditable);
}

bool RdsFileModel::setData(const QModelIndex &index, const QVariant &value, int role, Cache *cache)
{
	Q_UNUSED(index);
	Q_UNUSED(role);
	if (cache->name() == value.toString()) return(false); //if the new name is the same, we didn't change anything
	if (value.toString() == "") return(false);

	ReturnValue ret;

	if (cache->type() == "share")
	{
		RdsShareManager mgr;
		ret = mgr.init();
		if (ret.isError()) return(false);

		ret = mgr.share(cache->id());
		if (ret.isError()) return(false);

		RdsShare share = ret;
		ret = share.setName(value.toString());

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to rename share: " + ret.errString());
			return(false);
		}
	}
	else if (cache->type() == "folder")
	{
		if (!ret.isError())
		{
			ret = _manager->rename(cache->id(), value.toString());
		}

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to rename folder: " + ret.errString());
			return(false);
		}
	}
	else
	{
		return(false);
	}

	QString newname = ret.toString();
	manager()->renameEntity(cache->id(), newname);

	return(false);
}

void RdsFileModel::move(Cache *entity, Cache *parent)
{
	if (entity->type() == "folder")
	{
		ReturnValue ret = _manager->move(entity->id(), parent->id());

		if (ret.isError())
		{
			QMessageBox::critical(NULL, "Error:", "Failed to move: " + ret.errString());
			return;
		}
	}
	else
	{
		return;
	}
}
