/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation; either version 2 of the License, or (at  *
 *  your option) any later version.                                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  General Public License for more details.                               *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program; if not, write to the                          *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "publishmonitor.h"
#include <QTimer>
#include <QDebug>
#include <RdsSettings>

#include "main.h"

PublishMonitor::PublishMonitor(ServicePublisher *pub, QObject *parent)
		: QObject(parent)
{
	_pub = pub;
	QObject::connect(_pub, SIGNAL(registrationError(int)), this, SLOT(publishFailed(int)));
	QTimer *timer = new QTimer(this);
	QObject::connect(timer, SIGNAL(timeout()), this, SLOT(updateUptime()));
	timer->start(10000);
}


PublishMonitor::~PublishMonitor()
{
}

void PublishMonitor::publishFailed(int code)
{
	Q_UNUSED(code);
	qWarning() << "Failed to publish service. Trying again in 5 seconds...";
	QTimer::singleShot(5000,this,SLOT(publish()));
}

void PublishMonitor::publish()
{
	_pub->publish();
	if (getUptime() > 0)
		rdssettings()->setValue("uptime", getUptime());
}

void PublishMonitor::updateUptime()
{
	int uptime = getUptime();
	if (uptime > 0)
		rdssettings()->setValue("uptime", uptime);
}
