/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDAEMONMANAGER_H
#define RDSDAEMONMANAGER_H

#include <RdsEntityManager>
#include <QxtPimpl>

#define RDS_REGISTER_DAEMON(type, name) static RdsDaemonRegister<type> rds_daemon_registry_##type (name);

class RdsDaemonManagerPrivate;
class RdsDaemonInstance;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsDaemonManager : public RdsEntityManager
{
	Q_OBJECT;
	QXT_DECLARE_PRIVATE(RdsDaemonManager);
	QTRPC_SERVICEPROXY_PIMPL(RdsDaemonManager);
public:
	RdsDaemonManager(QObject *parent = 0);
	RdsDaemonManager(const RdsDaemonManager &other);
	~RdsDaemonManager();
	RdsDaemonManager& operator=(const RdsDaemonManager &other);

	ReturnValue auth(QtRpc::AuthToken token);
	ReturnValue listEntities(const QString &dn, bool loadmore) const;

public slots:
	ReturnValue list() const;
	ReturnValue stopService(const QString &name);
	ReturnValue startService(const QString &name);
	ReturnValue restartService(const QString &name);
	ReturnValue reloadService(const QString &name);
	ReturnValue reloadConfig(const QString &name);
};

class RdsDaemonContainer
{
	Q_DISABLE_COPY(RdsDaemonContainer);
public:
	RdsDaemonContainer(const QString& name);
	virtual RdsDaemonInstance* getInstance() = 0;
};

template<typename T>
class RdsDaemonRegister : protected RdsDaemonContainer
{
	RdsDaemonInstance* instance;
public:
	RdsDaemonRegister(const QString &name)
			: RdsDaemonContainer(name),
			instance(0)
	{
	}
	virtual RdsDaemonInstance* getInstance()
	{
		if (!instance)
			instance = new T();
		return instance;
	}
};

#endif
