/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#include "rdsdhcphost.h"
#include "rdsdhcphost_p.h"

#define RDS_LOCK \
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex()); \
	if(!qxt_d().values) \
		return ReturnValue(1, "Internal data object is missing in RdsDhcpHost");

QTRPC_SERVICEPROXY_PIMPL_IMPLEMENT(RdsDhcpHost);

RdsDhcpHost::RdsDhcpHost()
		: RdsDhcpValues()
{
}

RdsDhcpHost::RdsDhcpHost(const RdsDhcpHost &other)
		: RdsDhcpValues(other)
{
}

RdsDhcpHost::~RdsDhcpHost()
{
}

RdsDhcpHost& RdsDhcpHost::operator=(const RdsDhcpHost & other)
{
	RdsDhcpValues::operator=(other);
	return *this;
}

void RdsDhcpHost::setData(void* data)
{
	QMutexLocker ___locker(&RdsDhcpManagerPrivate::mutex());
	qxt_d().values = static_cast<RdsDhcpManagerPrivate::Host*>(data);
	RdsDhcpValues::setData(data);
}

ReturnValue RdsDhcpHost::setValues(const QVariantMap &map)
{
	RDS_LOCK;
	if (map.contains("fixed-address"))
		setValue("fixed-address", map.value("fixed-address").toString());
	return RdsDhcpValues::setValues(map);
}

ReturnValue RdsDhcpHost::setValue(const QString &key, const QString &value)
{
	RDS_LOCK;
	if (key == "fixed-address")
	{
		QString oldaddr = qxt_d().values->values.value("fixed-address", QVariant(QString::null)).toString();
		if (oldaddr != value)
		{
			if (!oldaddr.isEmpty())
				RdsDhcpManagerPrivate::excluded().removeOne(QHostAddress(oldaddr));
			if (!value.isEmpty())
				RdsDhcpManagerPrivate::excluded().append(QHostAddress(value));
		}
	}
	return RdsDhcpValues::setValue(key, value);
}

ReturnValue RdsDhcpHost::name() const
{
	RDS_LOCK;
	return qxt_d().values->name;
}

ReturnValue RdsDhcpHost::setName(const QString &name)
{
	RDS_LOCK;
	if (qxt_d().values->parent)
	{
		qxt_d().values->parent->hosts.remove(qxt_d().values->name);
		qxt_d().values->parent->hosts.insert(name, qxt_d().values);
	}
	qxt_d().values->name = name;
	return true;
}


