/***************************************************************************
 *  Copyright (C) 2011 by Resara LLC                                       *
 *  brendan@resara.com                                                     *
 *                                                                         *
 *  This program is free software; you can redistribute it and/or modify   *
 *  it under the terms of the GNU Lesser General Public License as         *
 *  published by the Free Software Foundation; either version 2 of the     *
 *  License, or (at your option) any later version.                        *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful, but    *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *  Lesser General Public License for more details.                        *
 *                                                                         *
 *  You should have received a copy of the GNU Lesser General Public       *
 *  License along with this program; if not, write to the                  *
 *  Free Software Foundation, Inc.,                                        *
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.              *
 *                                                                         *
 ***************************************************************************/
#ifndef RDSDHCPMANAGER_P_H
#define RDSDHCPMANAGER_P_H

#include <QxtPimpl>
#include <QVariantMap>
#include <QHostAddress>
#include <QMutex>
#include <RdsEntity>

#include "rdsdhcpmanager.h"
#include "rdsdhcpvalues.h"

class RdsDhcpValuesPrivate;

/**
	@author Chris Vickery <chris@resara.com>
*/
class RdsDhcpManagerPrivate : public QxtPrivate<RdsDhcpManager>
{
public:
	struct SharedNetwork;
	struct Group;
	struct Subnet;
	struct Host;
	struct DHCPValues
	{
		DHCPValues()
				: parent(0)
		{
		}
		~DHCPValues();
		DHCPValues& operator=(const DHCPValues& other);
		virtual ReturnValue getOutput(int indentation = 0) const;
		virtual RdsEntity listEntities(const QString &base) const;
		virtual void initializeValues();
		virtual QString type() const;
		QVariantMap values;
		QVariantMap options;
		QString otherValues;
		QList<Subnet*> subnetList;
		QList<Group*> groupList;
		QHash<QString, Subnet*> subnets;
		QHash<QString, Group*> groups;
		QHash<QString, SharedNetwork*> sharedNetworks;
		QHash<QString, Host*> hosts;
		QList<RdsDhcpValues*> refs;
		DHCPValues* parent;
	};

struct Subnet : public DHCPValues
	{
		Subnet& operator=(const Subnet& other);
		virtual ReturnValue getOutput(int indentation = 0) const;
		virtual RdsEntity listEntities(const QString &base) const;
		virtual QString type() const;
		QList<QPair<QHostAddress, QHostAddress> > getRanges() const;
		QList<QPair<QHostAddress, QHostAddress> > getFullRanges() const;
		void addRange(const QHostAddress &start, const QHostAddress &end);
		QHostAddress address;
		QHostAddress netmask;
		QList<QHostAddress> addresses;
		QString name;
	};

struct SharedNetwork : public DHCPValues
	{
		SharedNetwork& operator=(const SharedNetwork& other);
		virtual ReturnValue getOutput(int indentation = 0) const;
		virtual RdsEntity listEntities(const QString &base) const;
		virtual QString type() const;
		QString name;
	};

struct Group : public DHCPValues
	{
		Group& operator=(const Group& other);
		virtual ReturnValue getOutput(int indentation = 0) const;
		virtual RdsEntity listEntities(const QString &base) const;
		virtual QString type() const;
		QString name;
	};

struct Host : public DHCPValues
	{
		Host& operator=(const Host& other);
		virtual ReturnValue getOutput(int indentation = 0) const;
		virtual RdsEntity listEntities(const QString &base) const;
		virtual QString type() const;
		QString name;
	};

	RdsDhcpManagerPrivate()
	{
	}
	static QMutex &mutex();
	static DHCPValues*& values();
	static QList<QHostAddress>& excluded();

	bool insertValue(const QString &line, const QStringList &breadcrumb, const QString &key, const QString &value, DHCPValues* data = 0);
};

#endif
