/***************************************************************************
 *   Copyright (C) 2009 by Resara LLC   *
 *   brendan@resara.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RDSTEST_H
#define RDSTEST_H

#include <QtTest>
#include <QDebug>
#include <QList>
#include  <ReturnValue>

/**
	@author Brendan Powers <brendan@resara.com>
*/

class RdsTest; //This is stupid

class RdsTest
{
public:
	RdsTest();
	~RdsTest();

	virtual void runTest(const QStringList &args) = 0;
	virtual QString testName() const = 0;
	static void runTests();
	static QList<RdsTest *> *tests;
};

template <typename T> class RdsTestClass : public RdsTest
{
public:
	void runTest(const QStringList &args)
	{
		T test;
		QTest::qExec(&test, args);
	}
	QString testName() const
	{
		T test;
		return test.metaObject()->className();
	}
};

template <typename T> class RdsTestFactory
{
public:
	RdsTestFactory()
	{
		if (RdsTest::tests == NULL) RdsTest::tests = new QList<RdsTest *>();
		*RdsTest::tests << new RdsTestClass<T>();
	}
};

ReturnValue testForError(const QString &function, const ReturnValue& ret);
ReturnValue testForErrorFalse(const QString &function, const ReturnValue& ret);

#define REGISTER_TEST(classname) \
	RdsTestFactory<classname> __##classname##_RdsTestFactory =  RdsTestFactory<classname>();

#define TEST_FUNCTION(function) ___ret = function; \
	QVERIFY2((!___ret.isError()), qPrintable("\n"#function " returned the following error: \"" + ___ret.errString() + "\""));

// #define TEST_FUNCTION(x) ___ret;
#define TEST_FUNCTION_ERROR(function) ___ret = function; \
	QVERIFY2(___ret.isError(), qPrintable("\n"#function " did not return an error, and instead returned: \"" + ___ret.toString() + "\""));

// #define TEST_FUNCTION(function) testForError(#function, function);
// #define TEST_FUNCTION_ERROR(function) testForErrorFalse(#function, function);

#endif
