#!/usr/local/bin/ruby
# rdtoolconf.rb - create Makefile for rdtool.
# $Id: rdtoolconf.rb,v 1.23 2003/03/08 12:45:07 tosh Exp $

require 'mkmf'
require 'rbconfig'
require 'amstd/rbparams'

STDERR.print "creating Makefile\n"

$bindir = RubyParams::BINDIR
$siterubydir = RubyParams::SITE_RB
$rddir = CONFIG["datadir"] + "/ruby/rd"
$racc = "racc"

mfile = open("Makefile", "w")
mfile.print  <<"EOM"
#
# RDtool makefile

BIN_DIR = #{$bindir}
SITE_RUBY = #{$siterubydir}
RD_DIR = #{$rddir}

RUBY = #{CONFIG["ruby_install_name"]}
RUBY_OPT = -I.
RACC = #{$racc}
# RACC_OPT = -gv

RD_LIBS = rd/block-element.rb \\
          rd/complex-list-item.rb \\
          rd/desclist.rb \\
          rd/document-struct.rb \\
          rd/element.rb \\
          rd/filter.rb \\
          rd/inline-element.rb \\
          rd/labeled-element.rb \\
          rd/block-element.rb \\
          rd/complex-list-item.rb \\
          rd/desclist.rb \\
          rd/document-struct.rb \\
          rd/element.rb \\
          rd/filter.rb \\
          rd/inline-element.rb \\
          rd/labeled-element.rb \\
          rd/list.rb \\
          rd/loose-struct.rb \\
          rd/methodlist.rb \\
          rd/output-format-visitor.rb \\
          rd/package.rb \\
          rd/parser-util.rb \\
          rd/rbl-file.rb \\
          rd/rbl-suite.rb \\
          rd/rd-struct.rb \\
          rd/rd2html-lib.rb \\
          rd/rd2html-opt.rb \\
          rd/rd2man-lib.rb \\
          rd/rd2rdo-lib.rb \\
          rd/rd2rmi-lib.rb \\
          rd/rdfmt.rb \\
          rd/rdvisitor.rb \\
          rd/reference-resolver.rb \\
          rd/search-file.rb \\
          rd/tree.rb \\
          rd/version.rb \\
          rd/visitor.rb \\
          rd/dot.rd2rc

PARSERS = rd/rdblockparser.tab.rb \\
	  rd/rdinlineparser.tab.rb 

PARSERS_NONEXT = missing/rdblockparser.tab.rb \\
		 missing/rdinlineparser.tab.rb

RD_DOCS = README.rd
HTML_DOCS = README.html
MADE_FILE = rd/rdblockparser.tab.rb \\
            rd/rdinlineparser.tab.rb \\
            rd/rdblockparser.output \\
            rd/rdinlineparser.output \\
            README.html

all : rd2 $(RD_LIBS) $(PARSERS) $(HTML_DOCS)

utest : $(RD_LIBS) $(PARSERS)
	$(RUBY) -I. `which runtest.rb` test/*.rb

clean :
	rm -f $(MADE_FILE)
	rm -f ./Makefile

install : rd2 $(RD_LIBS) $(PARSERS)
	@$(RUBY) -r ftools -e 'File::install(ARGV[0], ARGV[1], 0755, true)' rd2 $(BIN_DIR)
	@$(RUBY) -r ftools -e 'File::makedirs(*ARGV)' $(SITE_RUBY)/rd
	@$(RUBY) -r ftools -e "dest = ARGV[-1]; ARGV.each do |file| File::install(file, dest, 0644, true) if file != dest end" $(RD_LIBS) $(PARSERS) $(SITE_RUBY)/rd

install-nonext : rd2 $(RD_LIBS) $(PARSERS_NONEXT)
	@$(RUBY) -r ftools -e 'File::install(ARGV[0], ARGV[1], 0755, true)' rd2 $(BIN_DIR)
	@$(RUBY) -r ftools -e 'File::makedirs(*ARGV)' $(SITE_RUBY)/rd
	@$(RUBY) -r ftools -e "dest = ARGV[-1]; ARGV.each do |file| File::install(file, dest, 0644, true) if file != dest end" $(RD_LIBS) $(PARSERS_NONEXT) $(SITE_RUBY)/rd

install-rmi2html : rmi2html.rb
	@$(RUBY) -r ftools -e 'File::install(ARGV[0], ARGV[1], 0755, true)' rmi2html.rb $(BIN_DIR)
	@$(RUBY) -r ftools -e 'File::install(ARGV[0], ARGV[1], 0644, true)' rd/rd2rmi-lib.rb $(SITE_RUBY)/rd

dist :
	$(RACC) $(RACC_OPT) -E -o missing/rd/rdblockparser.tab.rb rd/rdblockparser.ry
	$(RACC) $(RACC_OPT) -E -o missing/rd/rdinlineparser.tab.rb rd/rdinlineparser.ry

rd/rdblockparser.tab.rb : rd/rdblockparser.ry
	$(RACC) $(RACC_OPT) rd/rdblockparser.ry

rd/rdinlineparser.tab.rb : rd/rdinlineparser.ry
	$(RACC) $(RACC_OPT) rd/rdinlineparser.ry

TAGS : RBFILES
	rtags.rb `cat RBFILES`

update-version: rd/package.rb
	$(RUBY) -I. src/update-version.rb rd/tree.rb rd/visitor.rb rd2 
	$(RUBY) -I. src/update-version.rb rd/rd2html-lib.rb rd/rd2man-lib.rb

.SUFFIXES : .html .rd
.rd.html :
	$(RUBY) $(RUBY_OPT) rd2 -r rd/rd2html-lib.rb $< > $@
EOM
