require 'runit/testcase'
require 'runit/cui/mytestrunner'
require 'runit/topublic'

require 'rd/rdblockparser.tab'
require 'rd/rd-struct'

include RD

class TestParserUtil < RUNIT::TestCase
  include RUNIT::ToPublic
  def setup
    @p = to_public(RDParser).new
    @tree = tree = Tree.new_with_document_struct(DocumentStructure::RD)
    @p.instance_eval do
      @tree = tree
    end
  end

  def test_tree
    obj = Object.new
    obj.extend(ParserUtility)

    assert_exception(NotImplementedError) do
      obj.tree
    end
  end

  def test_add_children_to_element
    headline = to_public(Headline).new(1)
    string_element = StringElement.new "string"
    emphasis = Emphasis.new
    @p.add_children_to_element(headline, string_element, emphasis)
    assert_equal([string_element, emphasis], headline.children)

    textblock = to_public(TextBlock).new
    @p.add_children_to_element(textblock, emphasis, string_element)
    assert_equal([emphasis, string_element], textblock.children)

    textblock_empty = to_public(TextBlock).new
    @p.add_children_to_element(textblock_empty)
    assert_equal([], textblock_empty.children)
  end
end

if $0 == __FILE__
  RUNIT::CUI::TestRunner.run(TestParserUtil.suite)
end
