/* readln.h: header file for readln.c */
/* markus@mhoenicka.de 2-10-00 */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* A structure which contains information on the commands this program can understand. */

#include <readline/readline.h>
#include <readline/history.h>

typedef struct {
  char *name;			/* User printable name of the function. */
  Function *func;		/* Function to call to do the job. */
  char *doc;			/* Documentation for this function.  */
} COMMAND;

COMMAND *thecommandlist;

COMMAND *find_command(char *name, COMMAND *commands);
int execute_line (char *line, COMMAND *commands);
char *command_generator (char *text, int state);
char **refdb_completion (char *text, int start, int end);
void initialize_readline (void);

