/* strfncs.h header for strfncs.c */

/*
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* this is from readline/chardefs.h. */
#ifndef whitespace
#define whitespace(c) (((c) == ' ') || ((c) == '\t'))
#endif

/* this is different from whitespace in readline/chardefs.h */
#define full_whitespace(c) (((c) == ' ') || ((c) == '\t') || ((c) == '\n') || ((c) == '\r'))

/* this defines a log print facility. This prevents that a costly function
   call to log_print() is made just to find out that the log level does
   not call for any actions. Don't use this macro in another expression,
   just put "LOG_PRINT(level, your_string)" on its own line.
   Arguments: char* s  string to print
              int   l  minimum log level to get the string printed*/
#define LOG_PRINT(l,s) if (n_log_level >= l) {log_print(l,s);}

/* the mstr* functions use this value to reallocate memory for an autogrowing string. They will simply reallocate the existing size plus realloc_chunk if the requested size is not larger than that. This prevents that during string assembly where lots of small bits and pieces like commas, quotation marks, and brackets are appended, each one or two-byte increase in size needs an expensive call to realloc(). The higher the value for realloc_chunk, the less realloc() calls are necessary, but we may waste memory */
#define realloc_chunk 512

/* structure used in letter->entity replacements */
struct charent {
  char letter[5];  /* a string containing the (possibly multibyte) */
                   /* letter */
  size_t len;      /* length in bytes of letter */
  char entity[16]; /* null-terminated string containing the replacement */
                   /* entity string */
};

struct VERSIONINFO {
  int major;
  int minor;
  int minuscule;
};

int check_ip (char* server_ip);
int is_port(char *port);
int is_number(char *string);
int is_real_number(const char *string);
char *stripwhite(char *string, int mode, int type);
char* strup(char* string);
char* strdn(char* string);
char* stricap(char* string);
int compare_ptr(const void* ptr_one, const void* ptr_two);
char* mstrcat(char* destination, char* source, size_t* ptr_dest_len, size_t offset);
char* mstrcpy(char* destination, char* source, size_t* ptr_dest_len);
char* mstrncpy(char* destination, char* source, size_t n, size_t* ptr_dest_len);
char* mstrdup(char *buffer);
void free_all(void*** ptr_mem);
void insert_string(char *buffer, char *insert);
void remove_substring(char *buffer, size_t sublen);
char* sgml_entitize(char** buffer, struct charent* ptr_myents);
char *canonicalize_path(char *the_path);
char *strip_quote(char *the_string);
char *truncate_quoted_string(char *the_string, size_t len);
size_t escape_chars(char *dest, const char *orig, size_t orig_size, const char *toescape);
size_t unescape_chars(char *dest, const char *orig, size_t orig_size);
size_t escape_latex_chars(char *dest, const char *orig, size_t orig_size);
char* escape_latex_chars_copy(const char *orig, size_t orig_size);
int increment_suffix(char* suffix, int max_depth, int upper);
int parse_versioninfo(const char* version, struct VERSIONINFO* ver);
size_t count_the_flowers(const char *buffer, const char *letter, size_t len);
void replace_char_string(char *buffer, char *insert, size_t len);
size_t min_token_length(const char* string, const char* sep);
int replace_regexp_chars(char* string, char* regexp_chars, char replacement);
