
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Python Interface                                                      *
 *                                                                        *
 *  Copyright (c) 1999-2022, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,       *
 *  MA 02110-1301, USA.                                                   *
 *                                                                        *
 **************************************************************************/

#include "../pybind11/pybind11.h"
#include "enumerate/ordering.h"
#include "maths/matrix.h"
#include "../helpers.h"

using regina::MatrixInt;
using regina::PosOrder;

void addOrdering(pybind11::module_& m) {
    auto c = pybind11::class_<PosOrder>(m, "PosOrder")
        .def(pybind11::init<const MatrixInt&>())
        .def(pybind11::init<const PosOrder&>())
        .def("__call__", [](const PosOrder& p, long i, long j) {
            return p(i, j);
        })
    ;
    regina::python::add_output_custom(c, [](const PosOrder& o,
            std::ostream& s) {
        // A PosOrder object is basically like a lambda that has captured
        // a matrix by reference.  The main reason this class even exists
        // is because it was written long before lambdas were a part of C++.
        //
        // It doesn't make a lot of sense to output the internal data for
        // what is essentially a function object.
        s << "Compare row indices using position vectors";
    });
    // It doesn't really make sense to compare these objects either.
    regina::python::disable_eq_operators(c);
}

