#!/usr/bin/perl

use	strict		;
use	File::Find	;
use	File::Basename	;

my	$dirpfx		= "%attr(-,root,root) %dir " ;
my	$filepfx	= "%attr(-,root,root) "	     ;
my	$tgz		= 0 ;

A : while ($ARGV[0] =~ /^--/)
{
	if ($ARGV[0] eq "--tgz")
	{
		$dirpfx	= ""	;
		$filepfx= ""	;
		$tgz	= 1	;
		shift		;
		next	A	;
	}

	shift	;
}

my	$appname	= $ARGV[0] ;
my	$builddir	= $ARGV[1] ;
my	$rpmdir		= $ARGV[2] ;


my	@filelist	;
my	@dirlist	;

sub	wanted
{
	my	$file	= $File::Find::name ;
	my	$path	= $file ;

	$path	=~ s/$builddir// ;

	if ( -f $file)
	{
		push	@filelist, $path ;
		return	;
	}
	if ( -l $file)
	{
		push	@filelist, $path ;
		return	;
	}
	if ( -d $file )
	{
		push	@dirlist,  $file ;
		return	;
	}
}

sub	listToDirs
{
	my	$name	 ;
	my	@result	 ;
	my	%alldirs ;

	foreach my $dir (@dirlist)
	{
		$alldirs{$dir} = 0 ;
	}

	NAME : while ($name = shift)
	{
#		next NAME if ! -d dirname($builddir . $name) ;
#
#		foreach my $dir (@result)
#		{
#			next NAME if $dir eq dirname($name) ;
#		}
#
#		push	@result, dirname($name) ;

		my	$dest	= $builddir . $name ;

		DIR : foreach my $dir (@dirlist)
		{
			if ($dest =~ /^$dir/)
			{
#				print	"[$dest][$dir]\n" ;
				$alldirs{$dir} = 1 ;
			}
		}
	}

	foreach my $dir (keys %alldirs)
	{
		if ($alldirs{$dir})
		{
			$dir	=~ s/$builddir// ;
			push	@result, $dir ;
		}
	}

	return	sort { $a cmp $b } @result ;
}

sub	makeList
{
	my	$in	= shift	;
	my	@out	;

	if (! $tgz)
	{
		foreach my $dir  (&listToDirs (@$in))
		{
			push	@out, "$dirpfx$dir" ;
		}
	}

	foreach my $file (@$in)
	{
		push	@out, "$filepfx$file"
			if -f $builddir . $file && ! -l $builddir . $file ;
	}

	foreach my $file (@$in)
	{
		push	@out, "$filepfx$file"
			if -l $builddir . $file ;
	}

	return	@out	;
}

sub	makeListFile
{
	my	$file	= shift	;
	my	$in	= shift	;
	my	@list	= &makeList ($in) ;

	open	LIST, ">$file" ;
	print	LIST join "\n", @list ;
	print	LIST "\n" ;
	close	LIST	
}

find (\&wanted, $builddir) ;

my	@orphans  ;

my	@mappings =
(
	# Lib2, used for the QT-only builds
	#
	[
		'lib2',
		[],
		'/lib2/'
	],
	# Documentation (ie., the manual)
	#
	[
		'docs',
		[],
		'/doc/'
	],
	# Driver library used for rekall and for standalone
	# drivers.
	#
	[
		'drivers',
		[],
		'/libkbase_common\.so',
		'/libkbase_common\.la',
		'/rekall_dummy\.desktop'
	],
	# Python scripting common libraries and stuff
	#
	[
		'python-common',
		[],
		'libkbase_python.*\.so',
		'libkbase_python.*\.la',
		'libkbase_sip.*\.so',
		'libkbase_sip.*\.la',
		'/script/py/'
	],
	# Python scripting full version
	#
	[
		'python',
		[],
		'libkbase_script_py.*\.so',
		'libkbase_script_py.*\.la',
		'rekall_script_py.desktop',
		'/stock/component/py/'
	],
	# Python scripting runtime version
	#
	[
		'python-runtime',
		[],
		'libkbasert_script_py.*\.so',
		'libkbasert_script_py.*\.la',
		'rekallrt_script_py.desktop'
	],
	# ODBC driver. Note that the drivers preceed the libraries in
	# order to pick up the driver desktop files.
	#
	[
		'odbc',
		[],
		'/libkbase_driver_odbc\.so',
		'/libkbase_driver_odbc\.la',
		'/rekall_driver_odbc.desktop'
	],
	# IODBC driver.
	#
	[
		'iodbc',
		[],
		'/libkbase_driver_iodbc\.so',
		'/libkbase_driver_iodbc\.la',
		'/rekall_driver_iodbc.desktop'
	],
	# MySQL driver
	#
	[
		'mysql',
		[],
		'/libkbase_driver_mysql\.so',
		'/libkbase_driver_mysql\.la',
		'/rekall_driver_mysql.desktop'
	],
	# PgSQL driver
	#
	[
		'pgsql',
		[],
		'/libkbase_driver_pgsql\.so',
		'/libkbase_driver_pgsql\.la',
		'/rekall_driver_pgsql.desktop'
	],
	# XBase/XBSQL driver
	#
	[
		'xbase',
		[],
		'/libkbase_driver_xbase\.so',
		'/libkbase_driver_xbase\.la',
		'/rekall_driver_xbase.desktop'
	],
	# IBM DBCLI driver
	#
	[
		'db2cli',
		[],
		'/libkbase_driver_db2cli\.so',
		'/libkbase_driver_db2cli\.la',
		'/rekall_driver_db2cli.desktop'
	],
	# UniSQL driver
	#
	[
		'unisql',
		[],
		'/libkbase_driver_unisql\.so',
		'/libkbase_driver_unisql\.la',
		'/rekall_driver_unisql.desktop'
	],
	#  Extra stuff, mainly macros
	#
	[	'extra',
		[],
		'/libkbase_plugin_extra\.so',
		'/libkbase_plugin_extra\.la',
		'/rekall_plugin_extra\.desktop'
	],
	#  Runtim extra stuff, mainly macros
	#
	[	'rtextra',
		[],
		'/libkbasert_plugin_extra\.so',
		'/libkbasert_plugin_extra\.la',
		'/rekallrt_plugin_extra\.desktop'
	],
	# Libraries for the full version
	#
	[
		'libs',
		[],
		'/services/rekall_',
		'/libkbase_script.*\.so',
		'/libkbase_script.*\.la',
		'/libkbase\.so',
		'/libkbase\.la',
		'/libkbase_app\.so',
		'/libkbase_app\.la',
		'/librekall\.so',
		'/librekall\.la',
		'/libkbase_editor\.so',
		'/libkbase_editor\.la',
		'/libkbase_wizard\.so',
		'/libkbase_wizard\.la',
		'/libkbase_.*view\.so',
		'/libkbase_.*view\.la',
		'/rekall_.*\.desktop',
		'/rekallHelp',
		'/rekallCon',
		'/wizards'
	],
	# Libraries for the runtime version
	#
	[
		'rtlibs',
		[],
		'/services/rekallrt_',
		'/libkbasert_script.*\.so',
		'/libkbasert_script.*\.la',
		'/libkbasert\.so',
		'/libkbasert\.la',
		'/libkbasert_app\.so',
		'/libkbasert_app\.la',
		'/librekallrt\.so',
		'/librekallrt\.la',
		'/libkbasert_.*view\.so',
		'/libkbasert_.*view\.la',
		'/rekallrt_.*\.desktop'
	],
	# Stuff common to both full and runtime versions
	#
	[
		'common',
		[],
		'/libkbase_python.*\.so',
		'/libkbase_python.*\.la',
		'/libkbase_siplib.*\.so',
		'/libkbase_siplib.*\.la',
		'/libkbase_tkwidgets.*\.so',
		'/libkbase_tkwidgets.*\.la',
		'/libkbase_kde\.so',
		'/libkbase_kde\.la',
		'/libel_compile\.so',
		'/libel_compile\.la',
		'/libel_interp\.so',
		'/libel_interp\.la',
		'/dict',
		'/help/',
		'/icons/',
		'/pics/',
		'/rekallui.',
		'/highlight/',
		'/script/',
		'/keymap',
		'/rekall.png',
		'/LICENSE',
		'/rekall.mo'
	],
	# Full version executables
	#
	[
		'full',
		[],
		'/rekall$',
		'/rekall.desktop'
	],
	# Runtime version executables
	#
	[
		'runtime',
		[],
		'/rekallrt$',
		'/rekallrt.desktop'
	],
#	# Demo version executables
#	#
#	[
#		'demo',
#		[],
#		'/rekallDemo$',
#		'/rekallDemo.desktop'
#	],
#	# Demo runtime version executables
#	#
#	[
#		'demo-runtime',
#		[],
#		'/rekallrtDemo$',
#		'/rekallrtDemo.desktop'
#	],
	# Development headers and library .la files
	#
	[
		'devel',
		[],
		'/include/'
	],
	# KDE Plugins
	[	'kde',
		[],
		'/libkbase_plugin_kde\.so',
		'/libkbase_plugin_kde\.la',
		'/rekall_plugin_kde\.desktop',
		'/kdeparts\.lst'
	]
)	;

FILE : foreach my $file (@filelist)
{
	foreach my $map (@mappings)
	{
		for (my $idx = 2 ; $idx < scalar(@$map) ; $idx += 1)
		{
			if ($file =~ /$map->[$idx]/)
			{
				push	@{ $map->[1] }, $file ;
				next	FILE ;
			}
		}
	}


	push	@orphans, $file ;
}

if (scalar(@orphans) > 0)
{
	print	"Orphans:\n" ;

	foreach my $file (@orphans)
	{
		print	"\t", $file, "\n" ;
	}
}

LIST : foreach my $file (@mappings)
{
	&makeListFile
	(	"$rpmdir/file.list.$appname.$file->[0]",
		$file->[1]
	)	;
}
