/***************************************************************************
    file	         : kb_xbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_XBASE_H
#define	__KB_XBASE_H

struct	XBSQLTypeMap
{	xbShort		ident		;
	KB::IType	itype		;
	char		xtype	[16]	;
	uint		flags		;	/* Various flags	*/
	uint		length		;	/* Forced length	*/

	uint		deflen		;
	uint		defprec		;
}	TypeMap	;


/*  KBXBSQLType								*/
/*  -----------								*/
/*  This is the derived type for yhe XBaseSQL interface. It stores	*/
/*  the XBSQL type as well as the internal type.			*/

class	KBXBSQLType : public KBType
{
	XBSQLTypeMap	*m_typeInfo ;

public	:

	KBXBSQLType (XBSQLTypeMap *, uint, uint, bool) ;

	virtual	bool    isValid      (const QString &, KBError  &, const QString & = QString::null) ;
	virtual	void	getQueryText (KBDataArray   *, KBShared *, KBDataBuffer  &, QTextCodec * = 0) ;
}	;


/*  KBXBSQL								*/
/*  -------								*/
/*  Implementation class for the interface to the PostgreSQL database	*/

class	KBXBSQL : public KBServer
{
	XBaseSQL	*m_xBase	;
	long		m_startat	;
	long		m_keyseq	;
	bool		m_mapExpressions;
	bool		m_goSlow	;
	bool		m_readOnly	;

protected :

	virtual	bool	 	doConnect    	(KBServerInfo  *) ;
	virtual	bool		doListTables 	(KBTableDetailsList &, uint = KB::IsAny) ;
	virtual	bool		doListFields 	(KBTableSpec   &) ;
	virtual	bool		doCreateTable	(KBTableSpec   &,  bool, bool) ;
	virtual	bool		doRenameTable	(cchar *, cchar *, bool) ;
	virtual	bool		doDropTable  	(cchar *,	   bool) ;

public	:
	KBXBSQL	() ;
virtual~KBXBSQL () ;


	virtual	KBSQLSelect	*qrySelect 	(bool, const QString &, bool) ;
	virtual	KBSQLUpdate	*qryUpdate 	(bool, const QString &, const QString &) ;
	virtual	KBSQLInsert	*qryInsert 	(bool, const QString &, const QString &) ;
	virtual	KBSQLDelete	*qryDelete 	(bool, const QString &, const QString &) ;

	virtual	bool		command		(bool, const QString &, uint, KBValue *, KBSQLSelect ** = 0) ;

	virtual	bool		tableExists	(const QString &,  bool &) ;

	virtual	QString		listTypes 	() ;
	virtual	uint		optionFlags	() ;
	virtual	QString		mapExpression	(const QString &) ;

	inline	XBaseSQL	*getXBase 	() { return m_xBase   ; }
	QString			getNewKey 	() ;
}	;


/*  KBXBSQLQrySelect							*/
/*  ----------------							*/
/*  Implementation class for select queries on the MySQL database	*/

class	KBXBSQLQrySelect : public KBSQLSelect
{
	KBXBSQL		*m_server	;
	XBSQLSelect	*m_xSelect	;
	uint		m_lastDump	;

public	:

	KBXBSQLQrySelect (KBXBSQL *, bool, const QString &) ;
virtual~KBXBSQLQrySelect () ;

	virtual	bool	execute	 	(uint, const KBValue * ) ;
	virtual	KBValue	getField	(uint, uint, KBValue::VTrans) ;
	virtual	QString	getFieldName	(uint) ;

	virtual	void	dumpRow		(uint)	;
	virtual	void	dumpRowsTo	(uint)	;
	virtual	void	dumpAllRows	()	;
}	;


/*  KBXBSQLQryUpdate							*/
/*  ----------------							*/
/*  Implementation class for update queries on the MySQL database	*/

class	KBXBSQLQryUpdate : public KBSQLUpdate
{
	KBXBSQL		*m_server	;
	XBSQLUpdate	*m_xUpdate	;

public	:
	KBXBSQLQryUpdate (KBXBSQL *, bool, const QString &, const QString &) ;
virtual~KBXBSQLQryUpdate () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;

/*  KBXBSQLQryInsert							*/
/*  ----------------							*/
/*  Implementation class for insert queries on the MySQL database	*/

class	KBXBSQLQryInsert : public KBSQLInsert
{
	KBXBSQL		*m_server	;
	XBSQLInsert	*m_xInsert	;

public	:
	KBXBSQLQryInsert (KBXBSQL *, bool, const QString &, const QString &) ;
virtual~KBXBSQLQryInsert () ;

	virtual	bool	execute	   (uint, const KBValue *) ;
	virtual	bool	getNewKey  (const QString &, KBValue &, bool) ;
}	;

/*  KBXBSQLQryDelete							*/
/*  ----------------							*/
/*  Implementation class for delete queries on the MySQL database	*/

class	KBXBSQLQryDelete : public KBSQLDelete
{
	KBXBSQL		*m_server	;
	XBSQLDelete	*m_xDelete 	;

public	:
	KBXBSQLQryDelete (KBXBSQL *, bool, const QString &, const QString &) ;
virtual~KBXBSQLQryDelete () ;

	virtual	bool	execute	 (uint, const KBValue * ) ;
}	;



#endif	// __KB_XBASE_H
