/***************************************************************************
    file	         : kb_dbdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_DBDLG_H
#define	_KB_DBDLG_H

#include	<qtabwidget.h>
#include	<qtabbar.h>
#include	<qdict.h>


#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_serverdata.h"
#include	"kb_node.h"
#include	"kb_quickdlg.h"
#include	"kb_listwidget.h"
#include	"kbase.h"


#include	"tk_dirwatch.h"

/*  KBDBDlg								*/
/*  -------								*/
/*  This is the main database configuration and access dialog. It	*/
/*  contains tab'ed pages for:						*/
/*	Server setup							*/
/*	List of tables (by server)					*/
/*	Forms								*/
/*	Scripts								*/

class	KBDBaseDlg : public QWidget
{
	Q_OBJECT

	KBaseApp		*kbaseApp	;
	KBDBInfoData		*dbInfo	   	;
	KBServerDlg		*serverDlg 	;

#if	__KB_EMBEDDED
	QTabWidget		*m_window	;
#else
	KBListWidget		*m_window	;
#endif
	QDict<KBFileList  >	fileDict	;
	QDict<KBScriptList>	scriptDict	;
	QStringList		allParts	;

	QList<KBasePart   >	children	;
	TKDirWatch		dirWatch	;
	KBaseGUI		*m_gui		;

	void	loadParts	(QSize &)	;
	void	showPrinters	(KBQuickDlg::Option, KBLocation &) ;
	void	showGraphics	(KBQuickDlg::Option, KBLocation &) ;

	static	void	addIdentString		(const QString &, cchar *) ;

protected :

	void	addPage		(QWidget *, const QString &, const QString &, bool = true) ;

private slots :

	void	dirDirty	(const QString &) ;
	void	pageChanged	(QWidget *)	  ;

public	:

	KBDBaseDlg (QWidget *, KBaseApp *, const QString &, bool, KBaseGUI *) ;
       ~KBDBaseDlg () ;

	inline	bool	isShowing
		(	KBLocation 	&location
		)
	{
		return	location.dbInfo == dbInfo ;
	}
	inline	KBDBInfo*getDBInfo	()
	{
		return	dbInfo	;
	}

	void		showObjects	() ;
	void		showRawSQL	() ;
#if	! __KB_RUNTIME
	void		dumpDatabase	() ;
	void		loadDatabase	() ;
#endif
	bool		autoStart	(KBLocation &) ;

	inline	QString	getDBName 	() { return dbInfo->getDBName() ; }
	inline	QString	getDBPath 	() { return dbInfo->getDBPath() ; }

	static	QString	getIdentStrings	() ;
}	;

#endif	// _KB_DBDLG_H
