/***************************************************************************
    file	         : kb_listitem.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LISTITEM_H
#define	__KB_LISTITEM_H

#include	<qlistview.h>

#include "libapp_exports.h"

class		KBFileList	;
class		KBServerItem	;
class		KBObjectItem	;

/*  KBListItem								*/
/*  -----------								*/
/*  Wrapper round QListViewItem, used to provide an ordering function.	*/
/*  This allows us to have, for example, a "Create new table" entry	*/
/*  appear at the front of an otherwise ordered list.			*/

class	LIBAPP_API KBListItem : public QListViewItem
{
public	:

	enum	ItemType
	{
		Unknown,		/* List item type unknown	*/
		Server,			/* List item refers to server	*/
		Create,			/* List item is create		*/
		Object,			/* List item is object		*/
		Wizard			/* List item is create wizard	*/
	}	;

private	:

	QString		m_order		;
	ItemType	m_type		;

public	:

	KBListItem  (KBFileList	   *, const QString &, QString, QString = QString::null, QString = QString::null, QString = QString::null, QString = QString::null) ;
	KBListItem  (KBServerItem  *, const QString &, QString, QString = QString::null, QString = QString::null, QString = QString::null, QString = QString::null) ;
	KBListItem  (KBObjectItem  *, const QString &, QString, QString = QString::null, QString = QString::null, QString = QString::null, QString = QString::null) ;

	virtual	QString	key		(int, bool) const	;

	inline	ItemType type ()
	{
		return	 m_type	;
	}

	inline	void	 setType
		(	 ItemType type
		)
	{
		m_type	= type	;
	}
}	;

/*  KBServerItem							*/
/*  ------------							*/
/*  Derived class from KBListItem, user for the top level items in	*/
/*  the parent list view, which refer to servers.			*/

class	LIBAPP_API KBServerItem : public KBListItem
{
protected :

	KBFileList	*m_parent	;

public	:

	KBServerItem (KBFileList *, const QString &, QString) ;

	virtual	void	setOpen 	(bool) ;
}	;

/*  KBObjectItem							*/
/*  ------------							*/
/*  Derived class from KBListItem, user for the second level items in	*/
/*  the parent list view, which refer to objects.			*/

class LIBAPP_API KBObjectItem : public KBListItem
{
protected :

	KBServerItem	*m_parent	;

public	:

	KBObjectItem  (KBServerItem *, const QString &, QString, QString = QString::null, QString = QString::null, QString = QString::null) ;
}	;

#endif	// __KB_LISTITEM_H
