/***************************************************************************
    file	         : kb_navgui.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_navgui.h"

KBNavGUI::KBNavGUI
	(	QObject		*parent,
		const QObject	*receiver,
		const QString	&guiName
	)
	:
	KBaseGUI	(parent, receiver, guiName),
	m_located	(false)
{
}

KBNavGUI::~KBNavGUI ()
{
}

/*  KBNavGUI	 :							*/
/*  setFocusAtRow: Set focus row information for current block		*/
/*  hasData	 : bool		: Block has data			*/
/*  curRow	 : uint		: Current row number			*/
/*  numRows	 : uint		: Number of rows			*/
/*  inQuery	 : bool		: In a query				*/
/*  (returns)	 : void		:					*/

void	KBNavGUI::setFocusAtRow
	(	bool		hasData,
		uint		curRow,
		uint		numRows,
		bool		inQuery
	)
{
	bool	eFirst	;
	bool	ePrev	;
	bool	eNext	;
	bool	eLast	;
	bool	eAdd	;
	bool	eDelete	;
	bool	eQuery	;
	bool	eExecute;
	bool	eReload	;

	if (!m_located)
	{
		m_actFirst	= getAction ("KB_firstRecord") ;
		m_actPrev	= getAction ("KB_prevRecord" ) ;
		m_actNext	= getAction ("KB_nextRecord" ) ;
		m_actLast	= getAction ("KB_lastRecord" ) ;
		m_actAdd	= getAction ("KB_addRecord"  ) ;
		m_actDelete	= getAction ("KB_delRecord"  ) ;
		m_actStart	= getAction ("KB_startQuery" ) ;
		m_actExec	= getAction ("KB_execQuery"  ) ;
		m_actCancel	= getAction ("KB_cancelQuery") ;
		m_actReload	= getAction ("KB_redo"	     ) ;
		m_located	= true	;
	}

	if (hasData)
	{
		eFirst	= !inQuery && (curRow >  0)		;
		ePrev	= !inQuery && (curRow >  0)		;
		eNext	= !inQuery && (curRow != numRows    )	;
		eLast	= !inQuery && (curRow != numRows - 1)	;
		eAdd	= !inQuery ;
		eDelete	= !inQuery && (curRow <  numRows)	;
		eQuery	= !inQuery ;
		eExecute=  inQuery ;
		eReload	= !inQuery ;
	}
	else
	{
		eFirst	= false	;
		ePrev	= false	;
		eNext	= false	;
		eLast	= false	;
		eAdd	= false	;
		eDelete	= false	;
		eQuery	= false ;
		eExecute= false ;
		eReload	= false ;
	}

	if (m_actFirst  != 0) m_actFirst ->setEnabled (eFirst	) ;
	if (m_actPrev   != 0) m_actPrev  ->setEnabled (ePrev	) ;
	if (m_actNext   != 0) m_actNext  ->setEnabled (eNext	) ;
	if (m_actLast   != 0) m_actLast  ->setEnabled (eLast	) ;
	if (m_actAdd    != 0) m_actAdd   ->setEnabled (eAdd	) ;
	if (m_actDelete != 0) m_actDelete->setEnabled (eDelete	) ;
	if (m_actStart  != 0) m_actStart ->setEnabled (eQuery	) ;
	if (m_actExec   != 0) m_actExec  ->setEnabled (eExecute	) ;
	if (m_actCancel != 0) m_actCancel->setEnabled (eExecute	) ;
	if (m_actReload != 0) m_actReload->setEnabled (eReload	) ;
}
