/***************************************************************************
    file	         : kb_objbase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<time.h>
#include	<errno.h>

#include	<qstring.h>
#include	<qdict.h>
#include	<qfile.h>

#include	"tk_messagebox.h"

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_node.h"
#include	"kb_location.h"
#include	"kb_notifier.h"
#include	"kb_prompt.h"
#include	"kb_deleter.h"

#ifndef 	_WIN32
#include	"kb_objbase.moc"
#else
#include 	"kb_objbase.h"
#endif

#include	"kb_partwidget.h"
#include	"kb_part.h"



/*  KBObjBase	:							*/
/*  KBObjBase	: Constructor for object base class			*/
/*  parent	: QObject *	: Parent object				*/
/*  name	: cchar *	: Object name				*/
/*  (returns)	: KBObjBase	:					*/

KBObjBase::KBObjBase
	(	QObject		*parent,
		cchar		*name
	)
	:
	QObject	 (parent, name)
{
	fprintf	 (stderr, "KBObjBase::KBObjBase  [%p]\n", (void *)this) ;
	m_part	 = 0 	 ;
	m_modal	 = false ;
	m_inClose= false ;
	m_rc	 = 0	 ;
}

/*  KBObjBase	:							*/
/*  ~KBObjBase	: Destructor for object base class			*/
/*  (returns)	:		:					*/

KBObjBase::~KBObjBase ()
{
	fprintf	(stderr, "KBObjBase::~KBObjBase [%p]\n", (void *)this) ;
	DELOBJ	(m_part) ;
}

/*  KBObjBase								*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : bool	: Success				*/

bool	KBObjBase::saveDocumentAs ()
{
	QString	name 	= m_location.docName ;
	QString	locn	= m_location.docLocn ;
	KBError	error	;

	QString	text	= def() ;
	if (text.isNull())
	{
		TKMessageBox::sorry
		(	0,
			TR("Save Document"),
			TR("Document is null, not saving")
		)	;
		return	false	;
	}

	if (!doPromptSave
		(	QString(TR("Save %1 as ...")).arg(m_location.docType),
			QString(TR("Enter %1 name" )).arg(m_location.docType),
			name,
			locn,
			m_location.dbInfo,
			true
		))
		return	false	;

	if (!m_location.save (locn, name, text, error))
	{
		error.DISPLAY() ;
		return	false	;
	}

	m_location.docName = name ;
	m_location.docLocn = locn ;

	return	true	;
}

/*  KBObjBase								*/
/*  saveDocument: Save document						*/
/*  (returns)	: bool		: Success				*/

bool	KBObjBase::saveDocument ()
{
	if (m_location.docName.isEmpty())
		return	saveDocumentAs () ;

	QString	text	= def() ;
	if (text.isNull())
	{
		TKMessageBox::sorry
		(	0,
			TR("Save Document As ..."),
			TR("Document is null, not saving")
		)	;
		return	false	;
	}

	KBError	error	;
	if (!m_location.save (QString::null, QString::null, text, error))
	{
		error.DISPLAY() ;
		return	false	;
	}

	return	true	;
}

/*  KBObjBase								*/
/*  setPart	: Set part used fot this object				*/
/*  _part	: KBasePart *	: Part					*/
/*  _modal	: bool		: Part executing modally		*/
/*  (returns)	: void		:					*/

void	KBObjBase::setPart
	(	KBasePart	*_part,
		bool		_modal
	)
{
	m_part	= _part  ;
	m_modal	= _modal ;
}

/*  KBObjBase								*/
/*  closeObject	: Close down this object				*/
/*  (returns)	: void		:					*/

void	KBObjBase::closeObject ()
{
	fprintf
	(	stderr,
		"KBObjBase::closeObject: modal=%d inClose=%d\n",
		m_modal,
		m_inClose
	)	;

	/* Ignore this is either we are modal (we should be explicitely	*/
	/* destroyed on exit from the modal loop) or if we are already	*/
	/* closing.							*/
	if (m_modal  ) return ;
	if (m_inClose) return ;

	m_inClose = true ;
	KBDeleter::addObject (this) ;
//	delete this ;
}

/*  KBObjBase								*/
/*  showing	: Text if object is showing location			*/
/*  _location	: KBLocation &	: Location to check			*/
/*  (returns)	: bool		: True if showing			*/

bool	KBObjBase::showing
	(	KBLocation	&_location
	)
{
	return	m_location == _location ;
}
