/***************************************************************************
    file	         : kb_databuffer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_databuffer.h"


/*  KBDataBuffer							*/
/*  KBDataBuffer: Constructor for dynamic data buffer			*/
/*  (returns)	: KBDataBuffer	:					*/


KBDataBuffer::KBDataBuffer ()
	:
	QByteArray	()
{
	m_dataLength	= 0 ;
}

/*  KBDataBuffer							*/
/*  KBDataBuffer: Constructor for dynamic data buffer			*/
/*  alloc	: uint		: Initial space to allocate		*/
/*  (returns)	: KBDataBuffer	:					*/

KBDataBuffer::KBDataBuffer
	(	uint	alloc
	)
	:
	QByteArray	(alloc)
{
	m_dataLength	= 0 ;
}


/*  KBDataBuffer							*/
/*  ~KBDataBuffer: Constructor for dynamic data buffer			*/
/*  (returns)	 :		:					*/

KBDataBuffer::~KBDataBuffer ()
{
}

/*  KBDataBuffer							*/
/*  clear	: Clear buffer						*/
/*  (returns)	: void		  :					*/

void	KBDataBuffer::clear ()
{
	resize	(0)	;
	m_dataLength	= 0 ;
}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: const QString & : Text to append			*/
/*  (returns)	: void		  :					*/

void	KBDataBuffer::append
	(	const QString	&text
	)
{
	append	(text.utf8()) ;

}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: const QChar * : Character to append			*/
/*  (returns)	: void		:					*/

void	KBDataBuffer::append
	(	const QChar	&ch
	)
{
	append	(QString(ch)) ;

}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: const QCString & : Text to append			*/
/*  (returns)	: void		   :					*/

void	KBDataBuffer::append
	(	const QCString	&text
	)
{
	append	(text.data(), text.length()) ;
}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: char *	: Character to append			*/
/*  (returns)	: void		:					*/

void	KBDataBuffer::append
	(	char		ch
	)
{
	if (m_dataLength + 2 > size())
		resize (m_dataLength + 2 + KBDBINCR) ;

	QByteArray::data()[m_dataLength] = ch ;
	m_dataLength 	+= 1	;
}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: const char *	: Buffer to append			*/
/*  len		: uint		: Text length				*/
/*  (returns)	: void		:					*/

void	KBDataBuffer::append
	(	const char	*buff,
		uint		len
	)
{
	if (m_dataLength + len + 1 > size())
		resize (m_dataLength + len + KBDBINCR) ;

	memcpy	(&QByteArray::data()[m_dataLength], buff, len) ;
	m_dataLength 	+= len	;
}

/*  KBDataBuffer							*/
/*  append	: Append to buffer					*/
/*  text	: const char *	: String to append			*/
/*  (returns)	: void		:					*/

void	KBDataBuffer::append
	(	const char	*buff
	)
{
	append	(buff, strlen(buff)) ;
}

/*  KBDataBuffer							*/
/*  length	: Get buffer length					*/
/*  (returns)	: uint		: Buffer length				*/

uint	KBDataBuffer::length ()
{
	return	m_dataLength ;
}

/*  KBDataBuffer							*/
/*  data	: Return data buffer					*/
/*  (returns)	: const char *	: Data buffer				*/

const	char
	*KBDataBuffer::data ()
{
	/* Note that if the data length is zero then the QBtyeArray	*/
	/* databuffer will be null ...					*/
	if (m_dataLength > 0)
	{
		char	*dp = QByteArray::data() ;
		dp[m_dataLength] = 0 ;
		return	 dp ;
	}

	return	""	;
}
