/***************************************************************************
    file	         : kb_error.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#ifndef		_WIN32
#include	<unistd.h>
#endif

#include	"kb_classes.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"



uint 	LIBCOMMON_API	KBError::errDebug	;

/*  KBError								*/
/*  KBError	: Constructor for error object				*/
/*  (returns)	: KBError	:					*/

KBError::KBError ()
{
	m_etype	= None	;
	m_file	= 0	;
	m_lno	= 0	;
	m_errno	= -1	;	/* Defaults to invalid error code	*/
}

/*  KBError								*/
/*  KBError	: Constructor for error object				*/
/*  etype	: EType		  : Error type				*/
/*  message	: const QString & : Main error message			*/
/*  details	: const QString & : Extra error details			*/
/*  file	: cchar *	  : Originating file			*/
/*  lno		: uint		  : Oringinationg line number		*/
/*  (returns)	: KBError	  :					*/

KBError::KBError
	(	EType		etype,
		const QString	&message,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
	:
	m_etype		(etype),
	m_message	(message),
	m_details	(details),
	m_file		(file),
	m_lno		(lno)
{
	m_errno	= -1	;
}

/*  KBError								*/
/*  operator =	: Error assignment					*/
/*  e		: const KBError & : Error being assigned		*/
/*  (returns)	: void		:					*/

void	KBError::operator =
	(	const KBError	&e
	)
{
	m_etype		= e.m_etype	;
	m_message	= e.m_message	;
	m_details	= e.m_details	;
	m_file		= e.m_file	;
	m_lno		= e.m_lno	;
	m_errno		= e.m_errno	;

	if (errDebug >= 2)
		fprintf	(stderr, "error assign: %d [%s] [%s] %s:%d\n",
				 m_etype,
				 (cchar *)m_message,
				 (cchar *)m_details,
				 m_file == 0 ? "<null>" : m_file,
				 m_lno)	;
}

/*  KBError								*/
/*  display	: Display error						*/
/*  caption	: const QString & : Optional caption			*/
/*  dfile	: cchar *	  : Display source file			*/
/*  dlno	: uint		  : Display line number			*/
/*  (returns)	: void		  :					*/

void	KBError::display
	(	const QString	&caption,
		cchar		*dfile,
		uint		dlno
	)	const
{
	KBCallback *cb	= KBAppPtr::getCallback() ;

	if (cb != 0)
		if (cb->displayError (*this, caption, dfile, dlno))
			return	;

	cchar	*type	;

	switch (m_etype)
	{
		case None    : type = "No error"	; break ;
		case Info    : type = "Information"	; break ;
		case Warning : type = "Warning"		; break ;
		case Error   : type = "Error"		; break ;
		case Fault   : type = "Fault"		; break ;
		default	     : type = "Unknown"		; break ;
	}

	fprintf	(stderr, "KBError: %s\n", type) ;
	fprintf	(stderr, "       : %s\n", (cchar *)caption  ) ;
	fprintf	(stderr, "       : %s\n", (cchar *)m_message) ;
	fprintf	(stderr, "       : %s\n", (cchar *)m_details) ;
}

#if	! __KB_EMBEDDED

/*  KBError								*/
/*  display	: Display error						*/
/*  fd		: FILE *	: Error output stream			*/
/*  dfile	: cchar *	: Display source file			*/
/*  dlno	: uint		: Display line number			*/
/*  (returns)	: void		:					*/

void	KBError::display
	(	FILE		*fd
	)	const
{
	cchar	*type	;

	switch (m_etype)
	{
		case None    : type = "No error"	; break ;
		case Info    : type = "Information"	; break ;
		case Warning : type = "Warning"		; break ;
		case Error   : type = "Error"		; break ;
		case Fault   : type = "Fault"		; break ;
		default	     : type = "Unknown"		; break ;
	}

	fprintf	(fd, "KBError: %s\n", type) ;
	fprintf	(fd, "       : %s\n", (cchar *)m_message) ;
	fprintf	(fd, "       : %s\n", (cchar *)m_details) ;
}
#endif

void	KBError::EInfo
	(	const QString	&text,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
{
	KBError	(KBError::Info, text, details, file, lno).DISPLAY() ;
}

void	KBError::EWarning
	(	const QString	&text,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
{
	KBError	(KBError::Warning, text, details, file, lno).DISPLAY() ;
}

void	KBError::EError
	(	const QString	&text,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
{
	KBError	(KBError::Error, text, details, file, lno).DISPLAY() ;
}

void	KBError::EFault
	(	const QString	&text,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
{
	KBError	(KBError::Fault, text, details, file, lno).DISPLAY() ;
}

void	KBError::EFatal
	(	const QString	&text,
		const QString	&details,
		cchar		*file,
		uint		lno
	)
{
	KBError	(KBError::Fault, text, details, file, lno).DISPLAY() ;
	_exit	(1) ;
}

