/***************************************************************************
    file	         : kb_location.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_LOCATION_H
#define	__KB_LOCATION_H

#include "kb_classes.h"

#include "libcommon_exports.h"

class 	 KBLocnTypeMap	;



/*  KBLocation								*/
/*  ----------								*/
/*  The location of a document (a form, query, script, ...) is		*/
/*  specified by three things						*/
/*	(a) the database it is located in				*/
/*	(b) location in that database 					*/
/*	(c) the name within that location				*/
/*  The location object also provides other information, such as the	*/
/*  part factory for the object.					*/

class	LIBCOMMON_API	KBLocation
{
static	KBLocnTypeMap		*findByType	(const QString &) ;
static	KBLocnTypeMap		*findByExtn	(const QString &) ;

	bool			getData 	(cchar *, KBError &, QByteArray &) ;

	bool			saveToFile	(const QString &, const QString &, cchar *, uint, KBError &) ;
	bool			saveToDB	(const QString &, const QString &, cchar *, uint, KBError &) ;
	bool			renameFile	(const QString &, KBError &) ;
	bool			renameDB	(const QString &, KBError &) ;
	bool			removeFile	(KBError &) ;
	bool			removeDB	(KBError &) ;

public	:

	static	const char* 	m_pFile		;
	static	const char* 	m_pInline	;
	static	const char* 	m_pStock	;

	KBDBInfo		*dbInfo	;
	QString			docType	;
	QString			docLocn	;
	QString			docName	;
	QString			docExtn	;

	KBLocation		(KBDBInfo *, cchar *, const QString &, const QString & = "", const QString & = "") ;
	KBLocation		()	;

	bool		operator== 	(KBLocation &) ;

	QString		path		(const QString & = QString::null) ;

	QString		ident		()	;
	QString		title		()	;
	bool		exists		()	;

	bool		contents	(QByteArray &, KBError &) ;
	QString		contents	(KBError    &) ;
	QString		timestamp 	(KBError    &) ;

	bool		save		(const QString &, const QString &, const QString &, KBError &) ;
	bool		save		(const QString &, const QString &, cchar *,   uint, KBError &) ;
	bool		rename		(const QString &, KBError &) ;
	bool		remove		(KBError    &) ;

	inline	bool	isFile  () const { return docLocn == m_pFile	   ; }
	inline	bool	isInline() const { return docLocn == m_pInline	   ; }
	inline	bool	isStock () const { return docLocn == m_pStock	   ; }

	inline	bool	isInDB  () const { return !isFile() && !isInline() ; }

	KBPartFactory	*getFactory	() ;
	static	void	registerType	(cchar *, cchar *, const QString &, KBPartFactory *) ;
	static	QString	extnForType	(KBDBInfo *,       const QString &, const QString &) ;
}	;

#endif	// __KB_LOCATION_H
