/***************************************************************************
    file	         : kb_value.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_VALUE_H
#define	_KB_VALUE_H

#include	<qdatetime.h>
#include	<qcstring.h>
#include	<qtextcodec.h>

#include	"kb_shared.h"

#include	"libcommon_exports.h"



/*  KBDateTime								*/
/*  ----------								*/
/*  This class is used to hold decoded date/time information.		*/

class	LIBCOMMON_API	KBDateTime : public KBShared
{
	QDateTime	m_dt		;
	QByteArray	m_raw		;
	bool		m_valid		;
	bool		m_hasDate	;
	bool		m_hasTime	;
	
public	:

	enum	DateOrder
	{
		DayMonthYear,
		MonthDayYear
	}	;

	KBDateTime	(const QString   &) ;
	KBDateTime	(const QDateTime &) ;

	virtual	QString		format	  	(const QString &) const ;
	virtual	QString		defFormat 	(KB::IType)	  const ;

	inline	QDateTime	getDateTime	() const { return m_dt	      ; }
	inline	QDate		getDate		() const { return m_dt.date() ; }
	inline	QTime		getTime		() const { return m_dt.time() ; }

	inline	bool		isValid		() const { return m_valid     ; }
	inline	bool		hasDate		() const { return m_hasDate   ; }
	inline	bool		hasTime		() const { return m_hasTime   ; }

	static	void		setDateOrder	(DateOrder) ;
}	;


/*  KBDataArray								*/
/*  -----------								*/
/*  This is in effect a local replacement for QByteArray, and is used	*/
/*  to store the data associated with a KBValue. We do it ourselves for	*/
/*  a couple of reasons:						*/
/*									*/
/*  (a)	QByteArry is very momory-inefficient for small amounts of data	*/
/*	which is a problem on machines with relatively little memory.	*/
/*  (b)	We keep the data with an addition null just beyond the data so	*/
/*	that C-style string operations remain sane.			*/
/*									*/
/*  This is a structure and not a class so that we can play the old	*/
/*  allocate-to-size trick.						*/

struct	KBDataArray
{
	uint	m_refCount	;
	uint	m_length	;
	char	m_data[1]	;
}	;
#define	KBDASIZE(l)	(sizeof(KBDataArray)+(l))


/*  KBValue								*/
/*  -------								*/
/*  The KBValue class is used to pass database values around. Values	*/
/*  are always held as byte arrays (as returned in queries, and used in	*/
/*  updates and inserts). The class also contains:			*/
/*	(a) Type object 						*/
/*	(b) Null flag							*/
/*	(c) Decoded data (eg., for dates)				*/

class	LIBCOMMON_API	KBValue
{
	KBType		*type	;
	KBDataArray	*data	;
	KBShared	*d	;

	QString		formatNumber	(const QString  &, bool * = 0) const ;
	QString		formatCurrency	(const QString  &, bool * = 0) const ;

	void		store		(const QCString  &) ;
	void		setDateTime	(const QDateTime &) ;
	void		setDateTime	() ;

public	:

	KBValue	()	;

	/* Copy constructor. Needed to handle cases where the value	*/
	/* contains decoded data.					*/
	KBValue (const KBValue    &) ;
	KBValue	(const KBValue    &, KBType *) ;

	/* Constructors for various types. The type object defaults to	*/
	/* to corresponding type.					*/
	KBValue (int,		     KBType * = &_kbFixed ) ;
	KBValue (double,	     KBType * = &_kbFloat ) ;
	KBValue (const QString    &, KBType * = &_kbString) ;
	KBValue (const QByteArray &, KBType * = &_kbBinary, QTextCodec * = 0) ;
	KBValue (cchar *, uint,	     KBType * = &_kbBinary, QTextCodec * = 0) ;
	KBValue (cchar *,	     KBType * = &_kbString, QTextCodec * = 0) ;
	KBValue (const QDateTime  &, KBType * = &_kbDateTime) ;


	/* Null constructor. This constructs a value with the specified	*/
	/* type but which is marked as null.				*/
	KBValue (KBType *) ;

	/* Deformat constructor. This takes an additional format string	*/
	/* and an attempt is made to deformat the data using it.	*/
	KBValue (const QString    &, KBType *, const QString &) ;

	~KBValue() ;

	/* Assignment operator. Needed to handle some special cases,	*/
	/* such as where a value contains decoded data.			*/
	const KBValue	&operator  =	(const KBValue   &) ;
	const KBValue	&operator  =	(const QString   &) ;
	const KBValue	&operator  =	(cchar		 *) ;

	bool		operator  !=	(const KBValue   &)	const ;
	bool		operator  ==	(const KBValue   &) 	const ;

	QString		getRawText	()			const ;

	QString		getText		(const QString   &, bool       * = 0) const ;

	void		getQueryText	(KBDataBuffer	 &, QTextCodec * = 0) const ;
	QString		getQueryText	()			const ;

	const KBDateTime*getDateTime	()			const ;

	void		setRawData	(QByteArray	 &)	const ;
	void		resetRawData	(QByteArray	 &)	const ;

	char		*preallocate	(uint)			;

	inline	cchar	*dataPtr	()			const
	{
		return	data == 0 ? 0 : data->m_data   ;
	}
	inline	uint	dataLength	()			const
	{
		return	data == 0 ? 0 : data->m_length ;
	}

	KBType		*getType	() 			const ;
	bool		isNull		()			const ;
	bool		isEmpty		()			const ;

	bool		isTrue		()			const ;
	void		setTrue		() ;
	void		setFalse	() ;

	static	const	QString
			&deFormat	(const QString &, KBType *, const QString &) ;

	/* Used when retrieving/updating the server database, to	*/
	/* control data conversion for non-default codecs		*/
	enum	VTrans
	{
		VDefault	= 0,
		VText		= 1,
		VBinary		= 2
	}	;
}	;

#endif	// _KB_VALUE_H
