/***************************************************************************
    file	         : kb_attrdict.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qstring.h>
#include	<qdict.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_attrdict.h"



/*  KBAttrDict	:							*/
/*  KBAttrDict	: Constructor for attribute dictionary			*/
/*  orig	: const QDict<QString> &				*/
/*				: Dictionary to be copied		*/
/*  (returns)	: KBAttrDict	:					*/

KBAttrDict::KBAttrDict
	(	const QDict<QString> &orig
	)
{
	QDictIterator<QString> oIter (orig) ;
	QString		       *entry	    ;

	while ((entry = oIter.current()) != 0)
	{
		insert (oIter.currentKey(), new QString(*entry)) ;
		oIter += 1 ;
	}

	setAutoDelete (true) ;
}

/*  KBAttrDict	:							*/
/*  KBAttrDict	: Constructor for attribute dictionary			*/
/*  pset	: const PSet *	: Initial parameter set			*/
/*  (returns)	: KBAttrDict	:					*/

KBAttrDict::KBAttrDict
	(	const	PSet	*pset
	)
{
	setAutoDelete (true) ;

	if (pset != 0)
		while (pset->name != 0)
		{	addValue (pset->name, pset->value) ;
			pset	 += 1 ;
		}
}

/*  KBAttrDict	:							*/
/*  addValue	: Add value to parameter dictionary			*/
/*  name	: cchar *	: Dictionary key			*/
/*  val		: int		: Initial value				*/
/*  (returns)	: QString *	: String				*/

void	KBAttrDict::addValue
	(	cchar	*key,
		int	val
	)
{
	insert	(key, &(new QString)->setNum (val)) ;
}

/*  KBAttrDict	:							*/
/*  addValue	: Add value to parameter dictionary			*/
/*  name	: cchar *	: Dictionary key			*/
/*  val		: cchar *	: Initial value				*/
/*  (returns)	: QString *	: String				*/

void	KBAttrDict::addValue
	(	cchar	*key,
		cchar	*val
	)
{
	if ((val != 0) && (val[0] != 0))
		insert (key, new QString (val)) ;
}

/*  KBAttrDict	:							*/
/*  addValue	: Add value to parameter dictionary			*/
/*  name	: cchar *	  : Dictionary key			*/
/*  val		: const QString & : Initial value			*/
/*  (returns)	: QString *	  : String				*/

void	KBAttrDict::addValue
	(	cchar	*	key,
		const QString	&val
	)
{
	if (val.length () > 0)
		insert (key, new QString (val)) ;
}

/*  KBAttrDict	:							*/
/*  addValue	: Add value to parameter dictionary			*/
/*  name	: cchar *	  : Dictionary key			*/
/*  val		: const KBValue * : Initial value			*/
/*  (returns)	: QString *	  : String				*/

void	KBAttrDict::addValue
	(	cchar		*key,
		const KBValue	*val
	)
{
	addValue (key, val->getRawText()) ;
}


/*  KBAttrDict	:							*/
/*  print	: Generate XML format representation			*/
/*  element	: cchar *	: XML element name			*/
/*  term	: bool		: Terminate XML element			*/
/*  indent	: uint		: Indentation				*/
/*  (returns)	: QString	: XML representation			*/

QString	KBAttrDict::print
	(	cchar		*element,
		bool		term,
		uint		indent
	)
{
	QString			res	= QString("%1<%2").arg("", indent).arg(element) ;
	QDictIterator<QString>	dIter	(*this) ;

	while (dIter.current())
	{
		if (!dIter.current()->isEmpty())
			res += QString(" %1=\"%2\"")
				.arg( dIter.currentKey())
				.arg(*dIter.current   ()) ;
		dIter += 1 ;
	}

	if (term) res += "/"	;
	return	res + ">\n"	;
	res	+= term ? QString("/>") : res + ">" ;
}
