/***************************************************************************
    file	         : kb_attrnav.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_attrnav.h"

#if		! __KB_RUNTIME

#include	"kb_attrnavdlg.h"


/*  KBAttrNav								*/
/*  getAttrDlg	: Get dialog component for navigation			*/
/*  parent	: QWidget *		: Parent widget			*/
/*  item	: KBAttrItem *		: Associated item		*/
/*  attrDict	: QDict<KBAttrItem> &	: Attribute dictionary		*/
/*  (returns)	: KBAttrDlg *		: Actually KBAttrNavDlg		*/

KBAttrDlg
	*KBAttrNav::getAttrDlg
	(	QWidget			*parent,
		KBAttrItem		*item,
		QDict<KBAttrItem>	&attrDict
	)
{
	return	new KBAttrNavDlg (parent, this, item, attrDict) ;
}

/*  KBAttrNav								*/
/*  displayValue: Get display text for value				*/
/*  value	: const QString & : Actual value			*/
/*  (returns)	: QString	  : Display text for value		*/

QString	KBAttrNav::displayValue
	(	const QString	&value
	)
{
	if (value == "Yes") return TR("Both") ;
	if (value == "No" ) return TR("None") ;
	return	TR(value) ;
}

#endif

uint	KBAttrNav::getFlags ()
{
	QString	v = getValue() ;

	if (v == "Yes"	    ) return NAV_SCROLL|NAV_MINI ;
	if (v == "Scrollbar") return NAV_SCROLL	     ;
	if (v == "MiniNav"  ) return NAV_MINI	     ;
	return	0 ;
}


int	KBAttrNav::dummy ()
{
	return	0	;
}
