/***************************************************************************
    file	         : kb_editlistview.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_EDITLISTVIEW_H
#define	__KB_EDITLISTVIEW_H

#include 	"libkbase_exports.h"

#include	<qcheckbox.h>
#include	<qcombobox.h>
#include	<qlistview.h>

#include	"libkbase_exports.h"

#include	"tk_lineedit.h"


class		KBEditListView		;
class		KBEditListViewItem	;
#define		MAXCOL		(32)


/*  KBEditListCombo							*/
/*  ---------------							*/
/*  This is just a QComboBox but with public access to the popup	*/
/*  method.								*/

class LIBKBASE_API	KBEditListCombo : public QComboBox
{
public	:

	inline	KBEditListCombo
		(	QWidget	*parent
		)
		:
		QComboBox (parent)
	{
	}

	inline	void	showPopup ()
	{
		popup	() ;
	}
}	;


/*  ------------------------------------------------------------------  */

/*  KBEditListView							*/
/*  --------------							*/
/*									*/
/*  This class implements a single-level list view with customisably	*/
/*  editable cells, rather like QTable but more flexible.		*/

class	LIBKBASE_API	KBEditListView : public QListView
{
	Q_OBJECT

public	:

	enum	EdType
	{	EdLineEdit,
		EdCheckBox,
		EdComboBox
	}	;

private	:

	TKLineEdit		m_editor		;
	QCheckBox		m_check			;
	KBEditListCombo		m_combo			;

	KBEditListViewItem	*m_editItem		;
	KBEditListViewItem	*m_popItem		;
	KBEditListViewItem	*m_currItem		;
	QRect			m_currRect		;
	uint			m_popCol		;

	QWidget			*m_editWidget		;
	uint			m_editCol		;
	uint			m_numCols		;
	EdType			m_editType[MAXCOL]	;
	bool			m_firstIsIndex		;

	void		placeOverlay	(KBEditListViewItem *, uint) ;
	void		init		()		;
	uint		getRowNum	(QListViewItem*);
	void		numberRows	()		;

signals	:

	void		changed		(uint, uint)	;
	void		inserted	(uint)		;
	void		deleted		(uint)		;

	void		changed		(KBEditListViewItem *, uint)	;
	void		inserted	(KBEditListViewItem *)		;
	void		deleted		(KBEditListViewItem *)		;

protected :

	virtual	KBEditListViewItem
			*newItem	(QListViewItem *, QString = QString::null) ;
	
protected slots :

	virtual	void	itemClicked	(QListViewItem *, const QPoint &, int) ;
	void		textChanged	(const QString &) ;
	void		checkChanged	(bool) ;
	void		rightClick	(QListViewItem *, const QPoint &, int) ;
	void		insertRow	() ;
	void		deleteRow	() ;
	void		doShowZoom	() ;
	void		moveDown	() ;
	void		moveUp		() ;

public	:

	KBEditListView	(bool, QWidget * = 0, const char * = 0) ;
	KBEditListView	(bool, QWidget *, const char *, WFlags) ;

	virtual bool	eventFilter	(QObject   *, QEvent *) ;

	virtual	void	fillCombo	(QComboBox &, uint, const QString &) ; 
	virtual	bool	isEditable	(QListViewItem *, uint)   ;
	virtual	bool	isZoomable	(QListViewItem *, uint)   ;
	virtual	void	showZoom	(QListViewItem *, uint)   ;

	void		setEditType	(uint, EdType) ;
	void		cancelEdit	()		;

	friend	class	KBEditListViewItem	;
}	;


/*  ------------------------------------------------------------------  */

/*  KBEditListViewItem							*/
/*  ------------------							*/
/*  Wrapper round QListViewItem so that we can override the paintCell	*/
/*  methods and add a couple of extra functions.			*/

class LIBKBASE_API	KBEditListViewItem : public QListViewItem
{
protected :

	KBEditListView	*m_parent	;

	virtual	void	paintCell (QPainter *, const QColorGroup &, int, int, int) ;

public	:

	KBEditListViewItem (KBEditListView *,        QListViewItem *,
			    QString,		     QString = QString::null,
			    QString = QString::null, QString = QString::null,
			    QString = QString::null, QString = QString::null,
			    QString = QString::null, QString = QString::null) ; 
	KBEditListViewItem (KBEditListView *,
			    QString,		     QString = QString::null,
			    QString = QString::null, QString = QString::null,
			    QString = QString::null, QString = QString::null,
			    QString = QString::null, QString = QString::null) ; 
	KBEditListViewItem (KBEditListView *, 	     QListViewItem *) ;
	KBEditListViewItem (KBEditListView *) ;

	virtual	void	putText (int, const QString &) ;
}	;

#endif	// __KB_EDITLISTVIEW_H
