/***************************************************************************
    file	         : kb_gui.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#if		__KB_KDE
#include 	<kstddirs.h>
#include 	<kinstance.h>
#endif

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"
#include	"kb_gui.h"

static 	GUIElement kbaseGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot			  Element name		Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"&Close Document",	"fileclose",	ACCEL(Close),	SLOT(slotClose	      ()),"KB_closeDoc",	0,		"Close document"				},
{	GTCoded,	KB::GRNone,	true,	"Print",		"fileprint",	ACCEL(NoAccel),	SLOT(showAs 	   (int)),"KB_printDoc", 	KB::ShowAsPrint,   "Print document",				},
{	GTCoded,	KB::GRNone,	true,	"&Preview",		"kghostview",	ACCEL(NoAccel),	SLOT(showAs 	   (int)),"KB_preview",		KB::ShowAsPreview, "Preview print"				},
{	GTCoded,	KB::GRNone,	true,	"&First record",	"firstrecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_firstRecord",	KB::First,	"Move to the first record"			},
{	GTCoded,	KB::GRNone,	true,	"&Previous record",	"prevrecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_prevRecord",	KB::Previous,	"Move to the previous record"			},
{	GTCoded,	KB::GRNone,	true,	"&Next record",		"nextrecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_nextRecord",	KB::Next,	"Move to the next record"			},
{	GTCoded,	KB::GRNone,	true,	"&Last record",		"lastrecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_lastRecord",	KB::Last,	"Move to the last record"			},
{	GTCoded,	KB::GRDelta,	false,	"&Save record",		"saverecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_saveRecord",	KB::Save,	"Save current record"				},
{	GTCoded,	KB::GRNone,	true,	"&Add record",		"addrecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_addRecord",	KB::Add,	"Add a new record"				},
{	GTCoded,	KB::GRNone,	true,	"&Delete record",	"deleterecord",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_delRecord",	KB::Delete,	"Delete current record"				},
{	GTCoded,	KB::GRNone,	true,	"Start &query",		"filter",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_startQuery",	KB::Query,	"Start a database query"			},
{	GTCoded,	KB::GRNone,	true,	"&Execute query",	"find",		ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_execQuery",	KB::Execute,	"Execute database query"			},
{	GTCoded,	KB::GRNone,	true,	"&Cancel query",	"endquery",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_cancelQuery",	KB::Cancel,	"Cancel database query"				},
{	GTCoded,	KB::GRNone,	true,	"&First page",		"firstpage",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_firstPage",	KB::First,	"Move to the first page"			},
{	GTCoded,	KB::GRNone,	true,	"&Previous page",	"prevpage",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_prevPage",	KB::Previous,	"Move to the previous page"			},
{	GTCoded,	KB::GRNone,	true,	"&Next page",		"nextpage",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_nextPage",	KB::Next,	"Move to the next page"				},
{	GTCoded,	KB::GRNone,	true,	"&Last page",		"lastpage",	ACCEL(NoAccel),	SLOT(dbaseAction   (int)),"KB_lastPage",	KB::Last,	"Move to the last page"				},
{	GTAction,	KB::GRNone,	true,	"&Reload",		"redo",		ACCEL(NoAccel),	SLOT(reload	      ()),"KB_redo",	 	0,		"Reload data"					},
{	GTAction,	KB::GRNone,	true,	"Order columns",	"orderexpr",	ACCEL(NoAccel),	SLOT(orderByExpr      ()),"KB_orderByExpr",	0,		"Order columns alphabetically"			},

#if	! __KB_RUNTIME
{	GTCoded,	KB::GRNone,	true,	"&Data view",		"dataview",	ACCEL(NoAccel),	SLOT(showAs 	   (int)),"KB_dataView",	KB::ShowAsData,	   "Show document in data view"			},
{	GTAction,	KB::GRDelta,	false,	"&Save Document",	"filesave",	ACCEL(Save),	SLOT(saveDocument     ()),"KB_saveDoc",		0,		"Save definition"				},
{	GTAction,	KB::GRNone,	true,	"Save Document &As...",	0,		ACCEL(NoAccel),	SLOT(saveDocumentAs   ()),"KB_saveDocAs",	0,		"Save definition in a different location"	},
{	GTCoded,	KB::GRNone,	true,	"&Design view",		"designview",	ACCEL(NoAccel),	SLOT(showAs 	   (int)),"KB_designView",	KB::ShowAsDesign,  "Show document in design view"		},
{	GTCoded,	KB::GRAlign,	false,	"Align &top",		"aligntop",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_alignTop",	KB::AlignTop,	"Align control to top"				},
{	GTCoded,	KB::GRAlign,	false,	"Align &botton",	"alignbottom",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_alignBottom",	KB::AlignBottom,"Align controls to bottom"			},
{	GTCoded,	KB::GRAlign,	false,	"Align &left",		"alignleft",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_alignLeft",	KB::AlignLeft,	"Align controls to the left"			},
{	GTCoded,	KB::GRAlign,	false,	"Align &right",		"alignright",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_alignRight",	KB::AlignRight, "Align controls to the right"			},
{	GTCoded,	KB::GRAlign,	false,	"Same &width",		"samewidth",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_sameWidth",	KB::SameWidth,	"Make controls the same width"			},
{	GTCoded,	KB::GRAlign,	false,	"Same &height",		"sameheight",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_sameHeight",	KB::SameHeight,	"Make controls the same height"			},
{	GTCoded,	KB::GRAlign,	false,	"Same &size",		"samesize",	ACCEL(NoAccel),	SLOT(doCtrlAlign   (int)),"KB_sameSize",	KB::SameSize,	"Make controls the same size"			},
{	GTAction,	KB::GRCopy,	false,	"C&ut objects",		"editcut",	ACCEL(Cut),	SLOT(doCut	      ()),"KB_cutObjects",	0,		"Cut selected objects"				},
{	GTAction,	KB::GRCopy,	false,	"&Copy objects",	"editcopy",	ACCEL(Copy),	SLOT(doCopy	      ()),"KB_copyObjects",	0,		"Copy selected objects"				},
{	GTAction,	KB::GRCopy,	false,	"Save as component",	"savecomponent",ACCEL(NoAccel),	SLOT(doSaveComponent  ()),"KB_saveComponent",	0,		"Save selected objects as components"		},
{	GTAction,	KB::GRCopy,	false,	"Snap to grid",		"snaptogrid",	ACCEL(NoAccel),	SLOT(snapToGrid	      ()),"KB_snapToGrid",	0,		"Snap selected controls to grid"		},
{	GTAction,	KB::GRNone,	false,	"&Paste objects",	"editpaste",	ACCEL(Paste),	SLOT(doPaste	      ()),"KB_pasteObjects",	0,		"Paste copied or cut objects"			},
{	GTAction,	KB::GRCopy,	false,	"Properties",		"properties",	ACCEL(NoAccel),	SLOT(doProperties     ()),"KB_singleProp",	0,		"Update properties"				},
{	GTAction,	KB::GRAlign,	false,	"Common properties",	"commonprop",	ACCEL(NoAccel),	SLOT(doMultiProp      ()),"KB_multiProp",	0,		"Edit common properties"			}, 
{	GTToggle,	KB::GRNone,	true,	"Show object tree",	"tree",		ACCEL(NoAccel),	SLOT(showObjTree      ()),"KB_showObjTree",	0,		"Show object XML tree"				},
{	GTAction,	KB::GRNone,	true,	"Compile",		"compfile",	ACCEL(NoAccel),	SLOT(doCompile	      ()),"KB_compile",		0,		"Compile script source"				},
#endif

{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,			  0,		 	0,		0						}
}	;


static	QList<KBaseGUI>		allGUIs;

inline	LIBKBASE_API int	mapAccel
	(	GUIAccel	accel
	)
{
#if	__KB_KDE
	return	accel < 0 ? 0 :  KStdAccel::key(accel) ;
#endif
#if	__KB_TKC
	return	accel < 0 ? 0 : TKStdAccel::key(accel) ;
#endif
}


/*  ------------------------------------------------------------------  */


/*  KBaseGUI								*/
/*  KBaseGUI	: Constructor for KBase GUI client			*/
/*  parent	: QObject *	  : Parent object			*/
/*  receiver	: const QObject * : Receiver of signals			*/
/*  guiName	: const QString & : UI definition file			*/
/*  (returns)	: KBaseGUI	  :					*/

KBaseGUI::KBaseGUI
	(	QObject		*parent,
		const QObject	*receiver,
		const QString	&guiName
	)
	:
	QObject		(parent),
	m_receiver	(receiver),
	m_guiName	(guiName)
{
	m_hasStatusBar	= false ;
	allGUIs.append	(this) ;
}

/*  KBaseGUI								*/
/*  ~KBaseGUI	: Destructor for KBase GUI client			*/
/*  (returns)	:		:					*/

KBaseGUI::~KBaseGUI ()
{
	fprintf	(stderr, "KBaseGUI::~KBaseGUI ()\n") ;
	allGUIs.remove (this) ;
}

TKAction*KBaseGUI::makeAction
	(	const GUIElement    *guiSpec
	)
{
	TKAction	*act	;

	/* Create the appropriate action type as specified in the	*/
	/* information structure.					*/
	switch (guiSpec->m_gtype)
	{
		case GTAction :
			act	= new TKAction
				  (	guiSpec->m_text,
				  	guiSpec->m_icon,
					mapAccel(guiSpec->m_accel),
					m_receiver,
					guiSpec->m_slot,
					this
				  )	;
			break	;

		case GTToggle :
			act	= new TKToggleAction 
				  (	guiSpec->m_text,
				  	guiSpec->m_icon,
					mapAccel(guiSpec->m_accel),
					m_receiver,
					guiSpec->m_slot,
					this
				  )	;
			break	;

		case GTCoded  :
			act	= new TKAction
				  (	guiSpec->m_text,
				  	guiSpec->m_icon,
					mapAccel(guiSpec->m_accel),
					m_receiver,
					guiSpec->m_slot,
					this
				  )	;
			break	;

		default	:
			KBError::EFault
			(	QString("Unknown gtype %1").arg((int)guiSpec->m_gtype),
				QString::null,
				__ERRLOCN
			)	;
			return	0	;
	}

	act->setCode  (guiSpec->m_code  ) ;
	act->setGroup (guiSpec->m_ggroup) ;

	if (guiSpec->m_tip  != 0)
		act->setToolTip (guiSpec->m_tip ) ;

	/* Set the initial enabled state ....				*/
	act->setEnabled  (guiSpec->m_enable) ;
	m_actions.insert (guiSpec->m_name, act) ;
	return	act ;
}


/*  KBaseGUI								*/
/*  getAction	: Locate action for XML element				*/
/*  element	: QDomElement &	: Element in question			*/
/*  mySpec	: GUIElement  *	: Optional local specification		*/
/*  (returns)	: TKAction *	: Action or null if not found		*/

TKAction*KBaseGUI::getAction
	(	const QDomElement	&element,
		const GUIElement	*mySpec
	)
{
	TKAction	*act	;
	const QString	&name	= element.attribute("name") ;
	const QString	&mode	= element.attribute("mode") ;
	const QString	&gui	= element.attribute("gui" ) ;


	/* If the element specifies a mode then it should only appear	*/
	/* in that (MDI/SDI) mode.					*/
	if (!mode.isNull())
	{
		bool	useMDI	= KBAppPtr::getCallback()->useMDIMode() ;

		if ( useMDI && (mode == "sdi")) return 0 ;
		if (!useMDI && (mode == "mdi")) return 0 ;
	}

	/* Similarly, if a GUI is specified then only show the element	*/
	/* if running that (KDE/TKC) gui.				*/
	if (!gui.isNull())
	{
#if	__KB_KDE
		fprintf (stderr, "gui kde   [[%s]]\n", (cchar *)gui) ;
		if (gui != "kde"  ) return 0 ;
#endif

#if	__KB_TKC
#if	defined(_WIN32)
		fprintf (stderr, "gui win32 [[%s]]\n", (cchar *)gui) ;
		if (gui != "win32") return 0 ;
#else
		fprintf (stderr, "gui tkc   [[%s]]\n", (cchar *)gui) ;
		if (gui != "tkc"  ) return 0 ;
#endif
#endif
	}

	/* This is the clever bit, if I say so myself. GUI elements are	*/
	/* described once-and-for-all, so that the same description is	*/
	/* used one, however many different GUIs it appears in. Once	*/
	/* created, the action is stored in a dictionary so that it is	*/
	/* correctly reused for, say, a menu and a tool-bar. Finally,	*/
	/* by creating a separate instance of a GUI element for each	*/
	/* MDI child window's GUI, action state is preserved.		*/

	if ((act = m_actions.find (name)) != 0) return act ;

	if (mySpec != 0)
		for (const GUIElement *guiSpec = mySpec ; guiSpec->m_text != 0 ; guiSpec += 1)
			if (guiSpec->m_name == name)
				return	makeAction (guiSpec) ;

	for (const GUIElement *guiSpec = kbaseGUI ; guiSpec->m_text != 0 ; guiSpec += 1)
		if (guiSpec->m_name == name)
			return	makeAction (guiSpec) ;


	/* Not found in the definition tables so see if this is a	*/
	/* global action, such as snap-enable.				*/
	if ((act = KBAppPtr::getCallback()->globalAction (name)) != 0)
		return	act	;

	fprintf	(stderr, "GUI: cannot find \"%s\"\n", (cchar *)name) ;
	return	0 ;
}

/*  KBaseGUI								*/
/*  getAction	: Get action by (XML GUI) name				*/
/*  name	: const QString & : Name				*/
/*  (returns)	: TKAction *	  : Action or null			*/

TKAction*KBaseGUI::getAction
	(	const QString		&name
	)
{
	TKAction *action	;
	if ((action = m_actions.find (name)) != 0) return action ;
	return	0 ;
}

/*  KBaseGUI								*/
/*  addAction	: Add an action						*/
/*  name	: const QString & : Action name				*/
/*  action	: TKAction *	  : The action				*/
/*  (returns)	: void		  :					*/

void	KBaseGUI::addAction
	(	const QString	&name,
		TKAction	*action
	)
{
	m_actions.insert (name, action) ;
}

/*  KBaseGUI								*/
/*  setChecked	: Set action checked state				*/
/*  name	: const QString & : Name				*/
/*  checked	: bool		  : Checked state			*/
/*  (returns)	: void		  :					*/

void	KBaseGUI::setChecked
	(	const QString	&name,
		bool		checked
	)
{
	TKAction	*action ;

	if ((action = getAction (name)) == 0)
		return	;

	if (!action->inherits("TKToggleAction"))
		return	;

	((TKToggleAction *)(action))->setChecked (checked) ;
}

/*  KBaseGUI								*/
/*  setEnabled	: Set action enabled state by name			*/
/*  name	: const QString & : Name				*/
/*  enabled	: bool		  : Enabled state			*/
/*  (returns)	: void		  :					*/

void	KBaseGUI::setEnabled
	(	const QString	&name,
		bool		enable
	)
{
	TKAction	*action	;
	if ((action = getAction (name)) != 0) action->setEnabled (enable) ;
}

/*  KBaseGUI								*/
/*  setEnabled	: Set action enabled state by group			*/
/*  ggroup	: KB::GGroup	  : Action group			*/
/*  enabled	: bool		  : Enabled state			*/
/*  (returns)	: void		  :					*/

void	KBaseGUI::setEnabled
	(	KB::GGroup	ggroup,
		bool		enable
	)
{
	QDictIterator<TKAction>	aIter (m_actions) ;
	TKAction		*aPtr	;

	while ((aPtr = aIter.current()) != 0)
	{
		if (aPtr->getGroup () == ggroup)
			aPtr->setEnabled (enable) ;

		aIter	+= 1 ;
	}
}

/*  KBaseGUI								*/
/*  setAllChecked: Set all actions checked state			*/
/*  name	 : const QString & : Name				*/
/*  checked	 : bool		   : Checked state			*/
/*  (returns)	 : void		   :					*/

void	KBaseGUI::setAllChecked
	(	const QString	&name,
		bool		checked
	)
{
	LITER
	(	KBaseGUI,
		allGUIs,
		gui,
		gui->setChecked (name, checked)
	)
}

/*  KBaseGUI								*/
/*  setAllEnabled: Set all actions enabled state by name		*/
/*  name	 : const QString & : Name				*/
/*  enabled	 : bool		   : Enabled state			*/
/*  (returns)	 : void		   :					*/

void	KBaseGUI::setAllEnabled
	(	const QString	&name,
		bool		enable
	)
{
	LITER
	(	KBaseGUI,
		allGUIs,
		gui,
		gui->setEnabled (name, enable)
	)
}

/*  KBaseGUI								*/
/*  setAllEnabled: Set all actions enabled state by group		*/
/*  ggroup	 : KB::GGroup	  : Action group			*/
/*  enabled	 : bool		  : Enabled state			*/
/*  (returns)	 : void		  :					*/

void	KBaseGUI::setAllEnabled
	(	KB::GGroup	ggroup,
		bool		enable
	)
{
	LITER
	(	KBaseGUI,
		allGUIs,
		gui,
		gui->setEnabled (ggroup, enable)
	)
}

