/***************************************************************************
    file	         : kb_helper.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_HELPER_H
#define	__KB_HELPER_H

#include	"libkbase_exports.h"

#include	<qlayout.h>
#include	<qpushbutton.h>

#if		__KB_KDE
#include	<kdatepik.h>
#endif

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"
#include	"kb_formatdlg.h"


/*  KBHelperBase							*/
/*  ------------							*/
/*  Virtual base class from which helpers must be derived. Provides a	*/
/*  common setValue/getValue interface.					*/

class LIBKBASE_API	KBHelperBase
{
	QWidget		*_widget	;

public	:

	inline	KBHelperBase
		(	QWidget	*_widget
		)
		:
		_widget	(_widget)
	{
	}

	virtual	~KBHelperBase () {} ;

	virtual	void	setValue (const QString &) = 0 ;
	virtual QString	getValue () = 0 ;
	inline	QWidget	*widget	 () { return _widget ; }
}	;

/*  KBHelperFormat							*/
/*  --------------							*/
/*  Helper class for format selection					*/

class	LIBKBASE_API	KBFormatHelper : public KBFormatDlg, public KBHelperBase
{
public	:

	KBFormatHelper (QWidget *, const KBLocation &) ;
	virtual	~KBFormatHelper () {} ;

	virtual	void	setValue (const QString &) ;
	virtual QString	getValue () ;
}	;

#if	__KB_KDE

/*  KBHelperDate							*/
/*  ------------							*/
/*  Helper class for date selection					*/

class LIBKBASE_API	KBDateHelper : public KDatePicker, public KBHelperBase
{
public	:

	KBDateHelper (QWidget *, const KBLocation &) ;
	virtual	~KBDateHelper () {} ;

	virtual	void	setValue (const QString &) ;
	virtual QString	getValue () ;
}	;

#endif	// __KB_KDE

/*  KBHelperDlg								*/
/*  -----------								*/
/*  Dialog used for input helpers. Invoked with a helper specification	*/
/*  to show the corresponging helper.					*/

class LIBKBASE_API	KBHelperDlg : public _KBDialog
{
	Q_OBJECT

	QVBoxLayout		topLayout	;
	QHBoxLayout		butLayout	;
	QPushButton		bOK		;
	QPushButton		bCancel		;

	KBHelperBase		*dialog		;

private slots :

	void	clickOK 	()	 	;
	void	clickCancel	()		;

public	:

	KBHelperDlg (const QString &, const KBLocation &) ;
       ~KBHelperDlg () ;

	inline	QString	getValue ()
	{
		return	dialog == 0 ? QString::null : dialog->getValue () ;
	}

	void	setValue
		(	const QString 	&value
		)
	{
		if (dialog != 0) dialog->setValue (value) ;
	}

	static	QString	run	(const QString &, const QString &, const KBLocation &) ;
}	;


/*  KBHelperReg								*/
/*  -----------								*/
/*  Instance of this class can be created to register a helper.		*/

typedef	KBHelperBase	*(*MKHELPER) (QWidget *, const KBLocation &) ;

class LIBKBASE_API	KBHelperReg
{
	cchar		*helperName	;
	MKHELPER	helperFN	;
	KBHelperReg	*next		;

public	:

	KBHelperReg	(cchar *, MKHELPER) ;

	friend	class	KBHelperDlg	;

	static	bool	helperExists	(const QString &) ;
}	;

#endif	// __KB_HELPER_H
