/***************************************************************************
    file	         : kb_import.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_import.h"
#include	"kb_nodereg.h"


/*  KBImport								*/
/*  KBImport	: Constructor for import node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: Attribute list			*/
/*		: bool *	:					*/
/*  (returns)	: KBImport	:					*/

KBImport::KBImport
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBModule (parent, "KBImport", aList)
{
}

/*  KBImport								*/
/*  KBImport	: Constructor for import node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  name	: cchar *	: Module name				*/
/*  (returns)	: KBImport	:					*/

KBImport::KBImport
	(	KBNode	*parent,
		cchar	*name
	)
	:
	KBModule (parent, "KBImport", name)
{
}

/*  KBImport								*/
/*  KBImport	: Constructor for script node				*/
/*  parent	: KBNode *	: Parent node				*/
/*  name	: cchar *	: Module name				*/
/*  (returns)	: KBScript	:					*/

KBImport::KBImport
	(	KBNode		*parent,
		KBImport	*extant
	)
	:
	KBModule (parent, "KBImport", extant)
{
}


/*  KBImport								*/
/*  ~KBImport	: Destructor for import node				*/
/*  (returns)	:		:					*/

KBImport::~KBImport ()
{
}

/*  KBImport								*/
/*  replicate	: Replicate this import					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New choice node			*/

KBNode	*KBImport::replicate
	(	KBNode	*_parent
	)
{
	return	new KBImport (_parent, this) ;
}

NEWNODE(Import, (cchar *)0, KF_FORM|KF_REPORT)


/*  ------------------------------------------------------------------  */

/*  KBImportItem							*/
/*  ~KBImportItem: Destructor for import items				*/
/*  (returns)	 :		:					*/

KBImportItem::~KBImportItem ()
{
}

/*  KBImportItem							*/
/*  makeModule	: Instantiate a import module				*/
/*  parent	: KBNode *	  : Parent node				*/
/*  name	: const QString & : import name				*/
/*  (returns)	: KBModule *	  : New import module			*/

KBModule*KBImportItem::makeModule
	(	KBNode		*parent,
		const QString	&name
	)
{
	return	new KBImport (parent, name) ;
}

/*  ------------------------------------------------------------------  */

/*  KBImportDlg								*/
/*  KBImportDlg	: Constructor for import list dialog			*/
/*  parent	: QWidget *	    : Parent widget			*/
/*  node	: KBNode *	    : Parent node			*/
/*  modules	: QList<KBModule> & : List of imports			*/
/*  (returns)	: KBImportDlg	    :					*/

KBImportDlg::KBImportDlg
	(	QWidget		*parent,
		KBNode		*node,
		QList<KBModule>	&modules
	)
	:
	KBModuleDlg (parent, node)
{
	setModules  (modules) ;
}

/*  KBImportDlg								*/
/*  ~KBImportDlg: Constructor for import list dialog			*/
/*  (returns)	:		:					*/

KBImportDlg::~KBImportDlg()
{
}

/*  KBImportDlg								*/
/*  makeModuleItem: Make item for import				*/
/*  listBox	  : QListBox *	  : Parent list box			*/
/*  module	  : KBModule *	  : Actually the import			*/
/*  (returns)	  : KBModuleItem  : Import item				*/

KBModuleItem
	*KBImportDlg::makeModuleItem
	(	QListBox	*listBox,
		KBModule	*module
	)
{
	return	new KBImportItem (listBox, module->isImport()) ;
}

/*  KBImportDlg								*/
/*  makeModuleItem: Make item for import				*/
/*  listBox	  : QListBox *	    : Parent list box			*/
/*  name	  : const QString & : Import name			*/
/*  (returns)	  : KBModuleItem    : Inport item			*/

KBModuleItem
	*KBImportDlg::makeModuleItem
	(	QListBox	*listBox,
		const QString	&name
	)
{
	return	new KBImportItem (listBox, name) ;
}

