/***************************************************************************
    file	         : kb_nodereg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_NODEREG_H
#define	_KB_NODEREG_H


#include	"libkbase_exports.h"



/*  XML node type registration						*/
/*  --------------------------						*/
/*  Most node types that can be parsed from XML source files (forms,	*/
/*  queries, reports, ...) are registered via static instances of the	*/
/*  KBNodeReg class. This inserts an entry into a vector that is picked	*/
/*  up in the kb_parse file. Basically, for a node <KBMyNode ...> which	*/
/*  maps to a class KBMyNode, insert the macro call			*/
/*									*/
/*	NEWNODE(MyNode,menu_text,flags)					*/
/*									*/
/*  into the source file for KBMyNode.					*/


class	QPopupMenu	;
class	QObject		;


typedef	void	 (*MKPOPUP) (QPopupMenu *, QObject *) ;
typedef	KBNode	*(*MKNODE ) (KBNode *, const QDict<QString> &, bool *) ;

struct	LIBKBASE_API	NodeSpec
{
	const char	*nodeName	;
	const char	*msgText	;
	MKPOPUP		popupFunc	;
	MKNODE		nodeFunc	;
	uint		flags		;
}	;


class	LIBKBASE_API	KBNodeReg
{
public	:
	KBNodeReg (cchar *, const char *,	MKNODE, uint) ;
	KBNodeReg (cchar *, MKPOPUP,		MKNODE, uint) ;
}	;

#ifdef	__KB_NINST

#define	NEWNODE(t,i,f)							\
									\
	extern	KBNode	*new##t						\
			(	KBNode			*,		\
				const QDict<QString>	&,		\
				bool   			*		\
			)	;					\
	registerNode	("KB"#t, i, new##t, f)	;


#define	NEWNODENAMED(t,i,f,n)						\
									\
	extern	KBNode	*new##n						\
			(	KBNode			*,		\
				const QDict<QString>	&,		\
				bool			*		\
			)	;					\
	registerNode	("KB"#n, i, new##n, f)	;

#else

#define	NEWNODE(t,i,f)							\
									\
	KBNode	*new##t							\
		(	KBNode			*parent,		\
			const QDict<QString>	&aList,			\
			bool			*ok			\
		)							\
	{								\
		return	new KB##t (parent, aList, ok) ;			\
	}								\
	static	KBNodeReg reg##t ("KB"#t, i, new##t, f) ;

#define	NEWNODENAMED(t,i,f,n)						\
									\
	KBNode	*new##n							\
		(	KBNode			*parent,		\
			const QDict<QString>	&aList,			\
			bool			*ok			\
		)							\
	{								\
		return	new KB##t (parent, aList, "KB"#n, ok) ;		\
	}								\
	static	KBNodeReg reg##n ("KB"#n, i, new##n, f) ;

#endif

#endif	// _KB_NODEREG_H
