/***************************************************************************
    file	         : kb_pixmap.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qimage.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qpopupmenu.h>
#include	<qcursor.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_formblock.h"

#ifndef 	_WIN32
#include	"kb_pixmap.moc"
#else
#include 	"kb_pixmap.h"
#endif

#include	"kb_qtpixmap.h"
#include	"kb_nodereg.h"
#include	"kb_location.h"
#include	"kb_callback.h"
#include	"kb_appptr.h"
#include	"kb_layout.h"

#include	"tk_filedialog.h"
#include	"tk_messagebox.h"



struct	ImgMap
{
	cchar	*extn	;	/* Default file extension		*/
	cchar	*type	;	/* Type returned by QT image list	*/
	cchar	*patt	;	/* Patterns				*/
	cchar	*comment;	/* Comment for file dialog		*/
}	;

static	ImgMap imgMap[] =
{
{	"bmp",	"BMP",	"*.bmp",	"Bitmap images"			},
{	"gif",	"GIF",	"*.gif",	"GIF images"			},
{	"jpeg",	"JPEG",	"*.jpeg",	"JPG,JPEG images as .jpeg"	},
{	"jpg",	"JPEG",	"*.jpg",	"JPG,JPEG images as .jpg"	},
{	"pbm",	"PBM",	"*.pbm",	"Portable bitmap images"	},
{	"pgm",	"PGM",	"*.pgm",	"PGM images"			},
{	"png",	"PNG",	"*.png",	"Portable network graphics"	},
{	"ppm",	"PPM",	"*.ppm",	"PPM images"			},
{	"xbm",	"XBM",	"*.xbm",	"XBM images"			},
{	"xpm ",	"XPM ",	"*.xpm",	"X pixmap images"		},
}	;

static	QDict<ImgMap> dExtnToImg;


/*  imageFmtList: Build image format list for file selection		*/
/*  formats	: QStrList	: Formats supported bt QT		*/
/*  (returns)	: QString	: Selector text for file dialog		*/

QString	imageFmtList
	(	QStrList	formats
	)
{
	QString	res	;
	ImgMap	*map	;

	/* First time in, construct a dictionary to provide a mapping	*/
	/* back from the filename extension pattern.			*/
	if (dExtnToImg.count() == 0)
		for (uint typ = 0 ; typ < sizeof(imgMap)/sizeof(ImgMap) ; typ += 1)
		{	map = &imgMap[typ] ;
			dExtnToImg.insert (map->extn, map) ;
		}

	/* For each format supported by the QT libraries, scan the	*/
	/* image format lsit looking for matching entries, and add them	*/
	/* to the selector list. Doing this dynamically means that we	*/
	/* don't need to recompile for different QT builds.		*/
	for (uint fmt = 0 ; fmt < formats.count() ; fmt += 1)
		for (uint typ = 0 ; typ < sizeof(imgMap)/sizeof(ImgMap) ; typ += 1)
		{	map = &imgMap[typ] ;
			if (strcmp (formats.at(fmt), map->type) == 0)
			{	if (!res.isEmpty()) res += "\n" ;
				res += map->patt    ;
				res += "|"	    ;
				res += map->comment ;
			}
		}

	return	res ;
}

/*  ------------------------------------------------------------------  */

const	QPixmap	&scalePixmap
	(	const QPixmap	&pixmap,
		const QRect	&rect,
		uint		scale
	)
{
	static	QPixmap	pm ;

	switch (scale)
	{
		case 1 :
			pm = pixmap.convertToImage().scale(rect.size(), QImage::ScaleFree) ;
			return	pm ;

		case 2 :
			pm = pixmap.convertToImage().scale(rect.size(), QImage::ScaleMin ) ;
			return	pm ;

		case 3 :
			pm = pixmap.convertToImage().scale(rect.size(), QImage::ScaleMax ) ;
			return	pm ;

		default	:
			break	;
	}

	return	pixmap	;
}

/*  ------------------------------------------------------------------  */

/*  KBPixmap								*/
/*  KBPixmap	: Constructor for image control				*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBPixmap::KBPixmap
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem		(parent, "KBPixmap",	"expr",  	aList),
	frame		(this,	 "frame",		 	aList, KF_FORM),
	m_autosize	(this,	 "autosize",			aList),
	onChange	(this,	 "onchange",	"onPixmap",	aList)
{
	attribs.remove (&tabOrd ) ;
	attribs.remove (&onEnter) ;
	attribs.remove (&onLeave) ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!::pixmapPropDlg (this, "Pixmap", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true	;
	}
#endif
}

/*  KBPixmap								*/
/*  KBPixmap	: Constructor for image control				*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _pixmap	: KBPixmap *	: Extant pixmap				*/
/*  (returns)	: KBPixmap	:					*/

KBPixmap::KBPixmap
	(	KBNode		*_parent,
		KBPixmap	*_pixmap
	)
	:
	KBItem 		(_parent, "expr",  			_pixmap),
	frame		(this,	  "frame", 			_pixmap, KF_FORM),
	m_autosize	(this,	 "autosize",			_pixmap),
	onChange	(this,	  "onchange",	"onChoice",	_pixmap)
{
	attribs.remove (&tabOrd ) ;
	attribs.remove (&onEnter) ;
	attribs.remove (&onLeave) ;
}

/*  KBPixmap								*/
/*  ~KBPixmap	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBPixmap::~KBPixmap ()
{
}

/*  KBPixmap								*/
/*  makeCtrl	: Make a field control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBPixmap::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlPixmap (getDisplay(), this, drow) ;
}

/*  KBPixmap								*/
/*  userChange	: Selection changed notification			*/
/*  qrow	: uint		: Query row number			*/
/*  (returns)	: void		:					*/

void	KBPixmap::userChange
	(	uint	qrow
	)
{
	KBValue	args[2]	;
	bool	evRc	;

	args[0] = (int)qrow		    ;
	args[1] = KBValue ()		    ;
	eventHook (onChange, 2, args, evRc) ;

	KBItem::userChange (qrow) ;
}

/*  KBPixmap								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBPixmap::replicate
	(	KBNode	*_parent
	)
{
	return	new KBPixmap (_parent, this) ;
}

/*  KBPixmap								*/
/*  contextMenu	: Handle context menu					*/
/*  e		: QMouseEvent *	: The mouse event			*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: void		:					*/

void	KBPixmap::contextMenu
	(	QMouseEvent	*,
		uint		drow
	)
{
	QPopupMenu popup ;

	popupRow = drow	 ;

	popup.insertItem (TR("Cancel")) ;
	popup.insertItem (TR("&Save image" ), this, SLOT(saveImage ())) ;

	if (!isReadOnly())
	{
		popup.insertItem (TR("&Load image" ), this, SLOT(loadImage ())) ;
		popup.insertItem (TR("&Clear image"), this, SLOT(clearImage())) ;
	}

	popup.exec (QCursor::pos()) ;
}

/*  KBPixmap								*/
/*  saveImage	: Hande request to save an image			*/
/*  (returns)	: void		:					*/

void	KBPixmap::saveImage ()
{
	KBFileDialog fDlg 
		     (	".",
			imageFmtList (QImageIO::outputFormats()),
			qApp->activeWindow(),
			"saveimage",
			true
		     )	;

	fDlg.setMode	  (KBFileDialog::AnyFile) ;
	fDlg.setCaption   (TR("Save image ....")) ;
	if (!fDlg.exec  ()) return ;

	QString	name	  = fDlg.selectedFile  () ;
	QString filter	  = fDlg.currentFilter () ;
	if (name.isEmpty()) return ;


	/* Handle the vaguaries of the KDE/QTZ/QT3 file dialogs and	*/
	/* reduce the filter to an extension only.			*/
	int	dotp	  = filter.find ('.') ;
	if (dotp >= 0) filter = filter.mid (dotp + 1) ;


	/* Look up the extension amongst the know types. If not found	*/
	/* then we don't have anough imformation to save the image.	*/
	ImgMap *map = dExtnToImg.find (filter.lower()) ;
	if (map == 0)
	{	TKMessageBox::sorry
		(	0,
			QString(TR("Sorry, file extension %1 not recognised")).arg(filter),
			TR("Image type not known")
		)	;
		return	;
	}

	/* If the file name does not have an extension then add the	*/
	/* one appropriate to the image type.				*/
	if (QFileInfo(name).extension().isEmpty())
		name = QString("%1.%2").arg(name).arg(map->extn) ;

	fprintf
	(	stderr,
		"KBPixmap::saveImage [%s][%s]\n",
		(cchar *)name,
		map->type
	)	;

	((KBCtrlPixmap *)(ctrls[popupRow]))->saveImage (name, map->type) ;
}

/*  KBPixmap								*/
/*  loadImage	: Hande request to load an image			*/
/*  (returns)	: void		:					*/

void	KBPixmap::loadImage ()
{
	if (!isReadOnly())
	{
		KBFileDialog fDlg 
			     (	".",
				imageFmtList (QImageIO::inputFormats()),
				qApp->activeWindow(),
				"loadimage",
				true
			     )	;

		fDlg.setMode	  (KBFileDialog::ExistingFile) ;
		fDlg.setCaption   ("Load image ....") ;
		if (!fDlg.exec ()) return ;

		QString	name	  = fDlg.selectedFile () ;
		if (name.isEmpty()) return ;

		fprintf
		(	stderr,
			"KBPixmap::loadImage [%s]\n",
			(cchar *)name
		)	;

		((KBCtrlPixmap *)(ctrls[popupRow]))->loadImage (name) ;
	}
}

/*  KBPixmap								*/
/*  clearImage	: Handle request to clear an image			*/
/*  (returns)	: void		:					*/

void	KBPixmap::clearImage ()
{
	if (!isReadOnly())
		((KBCtrlPixmap *)(ctrls[popupRow]))->loadImage (QString::null) ;
}

/*  KBPixmap								*/
/*  setTabOrder	: Set tabbing order value				*/
/*  order	: int		: Order value				*/
/*  (returns)	: void		:					*/

void	KBPixmap::setTabOrder
	(	int
	)
{
	/* Null operation, users cannot tab into a row mark		*/
}

/*  KBPixmap								*/
/*  getTabOrder	: Get tabbing order value				*/
/*  (returns)	: int		: Order value				*/

int	KBPixmap::getTabOrder ()
{
	/* Always return a negative value; this keeps the row mark from	*/
	/* over being show in the tab order dialog			*/
	return	-1 ;
}

/*  KBPixMap								*/
/*  getVTrans	: Get value translation mode				*/
/*  (returns)	: KBValue::VTrans : Translation mode			*/

KBValue::VTrans	KBPixmap::getVTrans ()
{
	/* Images will be binary data and should therefore not be	*/
	/* translated.							*/
	return	KBValue::VBinary ;
}

#if	! __KB_RUNTIME
/*  KBPixmap								*/
/*  propertyDlg	: Show property dialog					*/
/*  (returns)	: bool		: Success				*/

bool	KBPixmap::propertyDlg ()
{
	if (!::pixmapPropDlg (this, "Pixmap", attribs)) return false ;

	updateProps () ;
	redraw	    () ;
	return true    ;
}
#endif

LIBKBASE_API NEWNODE(Pixmap, __TR("New &Pixmap"), KF_FORM|KF_REPORT|KF_BLOCK|KF_DATA)
