/***************************************************************************
    file	         : kb_qrysqldlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_propdlg.h"
#include	"kb_docroot.h"

#include	"kb_select.h"
#include	"kb_qrysql.h"

#ifndef 	_WIN32
#include 	"kb_qrysqldlg.moc"
#else
#include 	"kb_qrysqldlg.h"
#endif

#include	"tk_messagebox.h"


/*  KBQrySQLPropDlg							*/
/*  KBQrySQLPropDlg							*/
/*		: Constructor for query-query properties dialog		*/
/*  link	: KBLink *	 : Parent link				*/ 
/*  caption	: const char *   : Dialog box caption			*/
/*  attribs	: QList<KBAttr>& : List of attributes			*/
/*  (returns)	: KBQrySQLPropDlg :					*/

KBQrySQLPropDlg::KBQrySQLPropDlg
	(	KBQrySQL	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
	:
	KBPropDlg	(query, caption, attribs),
	query		(query)
{
}


/*  KBQrySQLPropDlg							*/
/*  ~KBQrySQLPropDlg							*/
/*		: Destructor for block properties dialog		*/
/*  (returns)	: void		:					*/

KBQrySQLPropDlg::~KBQrySQLPropDlg ()
{
}

/*  KBQrySQLPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBQrySQLPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Query							*/
	/* Use the tkEditor and enable the verify button so that the	*/
	/* user can check their SQL.					*/
	if (aName == "query")
	{
		tkEditor.setHighlight	("SQL") ;
		tkEditor.setText	(item->value()) ;
		tkEditor.show   	() ;

		setSizes ()	;
		bVerify.setEnabled (true) ;
		return	true	;
	}

	if (aName == "toptable")
	{
		QString	  sql	  = getProperty ("query") ;
		KBSelect  select  ;

		comboBox.clear	    ()   ;
		comboBox.insertItem ("") ;

		if (select.parseQuery (sql, 0))
			comboBox.insertStringList (select.tableList()) ;

		for (int idx = 0 ; idx < comboBox.count() ; idx += 1)
			if (comboBox.text(idx) == item->value())
			{	comboBox.setCurrentItem (idx) ;
				break	;
			}

		comboBox.show  () ;
		return	true	  ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBQrySQLPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Query							*/
	/* We parse the query to see if it is valid, and if not then	*/
	/* ask the user whether to accept it ...			*/
	if (aName == "query")
	{
		QString	  sql	 = tkEditor.text () ;
		KBSelect  select ;
		KBDBLink  dbLink ;

		if (!dbLink.connect (query->getDocRoot()->getLocation(), getProperty ("server")))
			if (TKMessageBox::questionYesNo
				(	0,
					QString(TR("Cannot parse SQL: %1\nSave anyway?"))
						.arg(dbLink.lastError().getDetails()),
					TR("SQL error")
				)
				!= TKMessageBox::Yes) return false ;

		if (!select.parseQuery (sql, &dbLink))
			if (TKMessageBox::questionYesNo
				(	0,
					QString(TR("Cannot parse SQL: %1\nSave anyway?"))
						.arg(select.lastError().getDetails()),
					TR("SQL error")
				)
				!= TKMessageBox::Yes) return false ;

		setProperty (item, sql) ;
		return	true  ;
	}

	if (aName == "toptable")
	{
		setProperty (item, comboBox.currentText()) ;
		return	true  ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBQrySQLPropDlg								*/
/*  clickVerify : Handle click of the verify button			*/
/*  (returns)	: void		:					*/

void	KBQrySQLPropDlg::clickVerify  ()
{
	QString	  sql	 = tkEditor.text () ;
	KBSelect  select ;
	KBDBLink  dbLink ;

	if (!dbLink.connect (query->getDocRoot()->getLocation(), getProperty ("server")))
	{
		dbLink.lastError().DISPLAY() ;
		return	;
	}

	if (!select.parseQuery (sql, &dbLink))
	{
		select.lastError().DISPLAY() ;
		return	;
	}
}

/*  qrySQLPropDlg							*/
/*		: Run the link properties dialog			*/
/*  query	: KBQrySQL *	: Parent link				*/ 
/*  caption	: cchar * 	: Dialog box caption			*/
/*  attribs	: QList<KBAttr>&: List of attributes			*/
/*  (returns)	: bool		: Success				*/

bool	qrySQLPropDlg
	(	KBQrySQL	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
{
	KBQrySQLPropDlg qDlg (query, caption, attribs) ;
	return	qDlg.exec () ;
}
