/***************************************************************************
    file	         : kb_qtcheck.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include 	"kb_qtcheck.moc"
#else
#include 	"kb_qtcheck.h"
#endif

#include	"kb_check.h"
#include	"kb_block.h"
#include	"kb_display.h"



/*  KBCtrlCheck								*/
/*  KBCtrlCheck	: Constructor for check box wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  check	: KBCheck *	: Parent check				*/
/*  drow	: uint		: Row number in field			*/
/*  (returns)	: KBCtrlCheck	:					*/

KBCtrlCheck::KBCtrlCheck
	(	KBDisplay	*display,
		KBCheck		*check,
		uint		drow
	)
	:
	KBCheckBox (display->getDisplayWidget()),
	KBControl  (this,  display, check, drow),
	m_check	   (check)
{
	connect	   (this, SIGNAL(clicked()), SLOT(clicked())) ;
}

/*  KBCtrlCheck								*/
/*  ~KBCtrlCheck: Destructor for check box wrapper			*/
/*  (returns)	:		:					*/

KBCtrlCheck::~KBCtrlCheck ()
{
}

/*  KBCtrlCheck								*/
/*  getValue	: Get value						*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBCtrlCheck::getValue ()
{
//	fprintf
//	(	stderr,
//		"KBCtrlCheck::getValue: [%s] c=[%d] [%s]\n",
//		(cchar *)m_check->getName(),
//		isChecked(),
//		(cchar *)m_check->getFieldType()->getDescrip()
//	)	;

	/* If the control is unchecked and the initial value was null	*/
	/* then return a null string.					*/
	if (!isChecked() && getIniValue().isNull())
		return	KBValue (m_check->getFieldType()) ;

	return	KBValue (isChecked(), m_check->getFieldType()) ;
}

/*  KBCtrlCheck								*/
/*  setValue	: Set value display row					*/
/*  value	: const KBValue &: Value to set				*/
/*  (returns)	: void		 :					*/

void	KBCtrlCheck::setValue
	(	const KBValue	&value
	)
{
	setChecked (value.isTrue()) ;
	KBControl::setValue (value) ;
}

/*  KBCtrlCheck								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBCtrlCheck::clearValue
	(	bool
	)
{
	setChecked (false) ;
}

/*  KBCtrlCheck								*/
/*  changed	: Test if field value has been changed			*/
/*  qrow	: uint		: Query row to check			*/

bool	KBCtrlCheck::changed ()
{
	/* Special case: This handles the situation where the inital	*/
	/* value is null, otherwise we get empty != null.		*/
	if (!isChecked() && getIniValue().isNull())
		return false ;

	return	isChecked() != getIniValue().isTrue() ;
}

/*  KBCtrlCheck								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlCheck::isEmpty ()
{
	return	! isChecked () ;
}

/*  KBCtrlCheck								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlCheck::giveFocus ()
{
	QCheckBox::setFocus () ;
}

/*  KBCtrlCheck								*/
/*  clicked	: Checkbox clicked notification				*/
/*  (returns)	: void		:					*/

void	KBCtrlCheck::clicked ()
{
	if (startUpdate ())
		m_check->userChange
		(	m_check->getBlock()->getCurDRow() + m_drow,
			isChecked()
		)	;
}

/*  KBCtrlCheck								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlCheck::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;
	redraw	()		 ;
}

/*  KBCtrlCheck								*/
/*  redraw	: Update to match design state				*/
/*  (returns)	: void		:					*/

void	KBCtrlCheck::redraw ()
{
	setReadOnly ((m_showing == KB::ShowAsData) && m_check->isReadOnly()) ;
}
