/***************************************************************************
    file	         : kb_qttabber.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_attr.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_event.h"
#include	"kb_tabber.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_qttabber.h"



/*  KBCtrlTabberBar							*/
/*  KBCtrlTabberBar							*/
/*		: Constructor for tab bar wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  atbber	: KBTabber *	: Parent tabber				*/
/*  design	: bool		: Design mode				*/
/*  (returns)	: KBCtrlTabber	:					*/

KBCtrlTabberBar::KBCtrlTabberBar
	(	KBDisplay	*display,
		KBTabberBar	*tabberBar
	)
	:
	QTabBar	  (display->getDisplayWidget()),
	KBControl (this, display, tabberBar),
	tabberBar (tabberBar)
{
	QPushButton::connect
	(	(QTabBar *)this,	SIGNAL(   selected(int)),
		tabberBar, 		SLOT  (tabSelected(int))
	) ;
}

/*  KBCtrlTabberBar							*/
/*  ~KBCtrlTabberBar							*/
/*		: Destructor for tab bar widget				*/
/*  (returns)	:		:					*/

KBCtrlTabberBar::~KBCtrlTabberBar ()
{
}

/*  KBCtrlTabberBar							*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlTabberBar::giveFocus ()
{
	QTabBar::setFocus () ;
}

/*  KBCtrlTabberBar							*/
/*  addTab	: Add a new tab						*/
/*  label	: const QString & : Tab text				*/
/*  (returns)	: int		  : Tab identifier			*/

int	KBCtrlTabberBar::addTab
	(	const QString	&label
	)
{
	return	QTabBar::addTab (new QTab (label)) ;
}

/*  KBCtrlTabberBar							*/
/*  setTabText	: Set tab text						*/
/*  id		: int		  : Tab identififer			*/
/*  text	: const QString & : Text				*/
/*  (returns)	: void							*/

void	KBCtrlTabberBar::setTabText
	(	int		id,
		const QString	&text
	)
{
	QTab *t = tab (id) ;
	if (t != 0) t->setText (text) ;
}

/*  KBCtrlTabberBar							*/
/*  removeTab	: Remove a tab						*/
/*  id		: int		: Tab identififer			*/
/*  (returns)	: void							*/

void	KBCtrlTabberBar::removeTab
	(	int		id
	)
{
	QTab *t = tab (id) ;
	if (t != 0) QTabBar::removeTab (t) ;
}

/*  KBCtrlTabberBar								*/
/*  write	: Write field 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlTabberBar::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		extra	= 0  ;
		return	true ;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
