/***************************************************************************
    file	         : kb_query.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dblink.h"
#include	"kb_node.h"
#include	"kb_query.h"
#include	"kb_table.h"
#include	"kb_nodereg.h"


/*  KBQuery								*/
/*  KBQuery	: Constructor for parsed query node			*/
/*  aList	: const QDict<QString> &				*/
/*				  : Attribute set			*/
/*  (returns)	: KBQuery	  :					*/

KBQuery::KBQuery
	(	const QDict<QString>	&aList
	)
	:
	KBNode	(0, 	"KBQuery"),
	server	(this,	"server",	aList, KF_REQD)
{
	changed	= false ;
}

/*  KBQuery								*/
/*  KBQuery	: Constructor for new query node			*/
/*  (returns)	: KBQuery	:					*/

KBQuery::KBQuery ()
	:
	KBNode	(0,	"KBQuery"),
	server	(this,	"server",	"", KF_REQD)
{
	changed	= false ;
}

/*  KBQuery								*/
/*  ~KBQuery	: Destructor for query node				*/

KBQuery::~KBQuery ()
{
}

/*  KBQuery								*/
/*  setServer	: Set server name					*/
/*  svName	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBQuery::setServer
	(	const QString	&svName
	)
{
	server.setValue (svName) ;
}


/*  KBQuery								*/
/*  getQueryInfo: Get query information					*/
/*  svName	: QString &	     : Server name			*/
/*  tabList	: QList<KBTable> &   : Returned list of tables		*/
/*  exprList	: QList<KBQryExpr> & : Returned list of expressions	*/

void	KBQuery::getQueryInfo
	(	QString			&svName,
		QList<KBTable  >	&tabList,
		QList<KBQryExpr>	&exprList
	)
{
	svName	= server.getValue () ;

	CITER
	(	Table,
		t,
		tabList .append (t)
	)
	CITER
	(	QryExpr,
		e,
		exprList.append (e)
	)
}

/*  KBQuery								*/
/*  printNode	: Output node XML					*/
/*  text	: QString &	: Result string				*/
/*  indent	: int		: Indent level of this node		*/
/*  (returns)	: void		:					*/

void	KBQuery::printNode
	(	QString	&text,
		int	indent
	)
{
	extern	QString	kbXMLEncoding() ;
	QString		nodeText ;

	/* Implement this specially, since we need to output the XML	*/
	/* header.							*/
	text	+= QString
		   (	"<?xml version=\"1.0\" encoding=\"%1\"?>\n"
			"<!DOCTYPE KBaseQuery SYSTEM \"kbasequery.dtd\">\n"
		   )
		   .arg	(kbXMLEncoding()) ;

	text	+= QString("%1<%2").arg("", indent).arg(getElement()) ;
	for (uint idx = 0 ; idx < attribs .count () ; idx += 1)
		attribs.at(idx)->printAttr(text, nodeText, indent + 2) ;
	text	+= ">\n" ;

	LITER
	(	KBNode,
		children,
		child,
		child->printNode (text, indent+2)
	)

	text	+= nodeText ;
	text	+= QString("%1</%2>\n").arg("", indent).arg(getElement()) ;
}
