/***************************************************************************
    file	         : kb_summary.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_display.h"
#include	"kb_ctrl.h"
#include	"kb_summary.h"
#include	"kb_qtsummary.h"
#include	"kb_nodereg.h"

#include	"kb_writer.h"
#include	"kb_layout.h"


void	KBSummary::sumUnknown
	(	const KBValue	&
	)
{
}

void	KBSummary::sumSumInt
	(	const KBValue	&value
	)
{
	if (nVals == 0) iVal = 0 ;
	iVal	+= value.getRawText().toInt() ;
}

void	KBSummary::sumSumDouble
	(	const KBValue	&value
	)
{
	if (nVals == 0) dVal = 0 ;
	dVal	+= value.getRawText().toDouble() ;
}

void	KBSummary::sumMaxInt
	(	const KBValue	&value
	)
{
	int	v	= value.getRawText().toInt() ;
	if ((nVals == 0) || (v > iVal)) iVal = v ;
}

void	KBSummary::sumMaxDouble
	(	const KBValue	&value
	)
{
	double	v	= value.getRawText().toDouble() ;
	if ((nVals == 0) || (v > dVal)) dVal = v ;
}

void	KBSummary::sumMinInt
	(	const KBValue	&value
	)
{
	int	v	= value.getRawText().toInt() ;
	if ((nVals == 0) || (v < iVal)) iVal = v ;
}

void	KBSummary::sumMinDouble
	(	const KBValue	&value
	)
{
	double	v	= value.getRawText().toDouble() ;
	if ((nVals == 0) || (v < dVal)) dVal = v ;
}


/*  KBSummary								*/
/*  KBSummary	: Constructor for simple form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*  ok		: bool *	: Success				*/
/*  (returns)	: KBNode	:					*/

KBSummary::KBSummary
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*ok
	)
	:
	KBItem	(parent, "KBSummary",	"expr",  aList),
	fgcolor	(this,   "fgcolor",	aList),
	bgcolor	(this,   "bgcolor",	aList),
	font	(this,	 "font",	aList),
	format	(this,	 "format",	aList),
	align	(this,	 "align",	aList),
	summary	(this,	 "summary",	aList, KF_REQD),
	reset	(this,	 "reset",	aList)
{
	nVals	= 0 ;

#if	! __KB_RUNTIME
	if (ok != 0)
	{
		if (!summaryPropDlg (this, "Summary", attribs))
		{	delete	this	;
			*ok	= false	;
			return	;
		}

		*ok	= true		;
	}
#endif
	if (getParent() != 0) report = getParent()->getReport () ;
}

/*  KBSummary								*/
/*  KBSummary	: Constructor for simple form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _summary	: KBSummary *	: Extant summary control		*/
/*  (returns)	: KBSummary	:					*/

KBSummary::KBSummary
	(	KBNode		*_parent,
		KBSummary	*_summary
	)
	:
	KBItem	(_parent, "expr",	_summary),
	fgcolor	(this,    "fgcolor",	_summary),
	bgcolor	(this,    "bgcolor",	_summary),
	font	(this,	  "font",	_summary),
	format	(this,    "format", 	_summary),
	align	(this,	  "align",	_summary),
	summary	(this,	  "summary",	_summary, KF_REQD),
	reset	(this,	  "reset",	_summary)
{
	nVals	= 0 ;
	if (getParent() != 0) report = getParent()->getReport () ;
}

/*  KBSummary								*/
/*  ~KBSummary	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBSummary::~KBSummary ()
{
}

/*  KBSummary								*/
/*  makeCtrl	: Make a field control					*/
/*  drow	: uint		: Display row number			*/
/*  (returns)	: KBControl *	: New control				*/

KBControl
	*KBSummary::makeCtrl
	(	uint		drow
	)
{
	return	new KBCtrlSummary (getDisplay(), this, drow) ;
}

/*  KBSummary								*/
/*  replicate	: Replicate this field					*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New field node			*/

KBNode	*KBSummary::replicate
	(	KBNode	*_parent
	)
{
	return	new KBSummary (_parent, this) ;
}

/*  KBSummary								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBSummary::showAs
	(	KB::ShowAs	mode
	)
{
	KBItem::showAs (mode) ;
}

/*  KBSummary								*/
/*  setFieldType: Set field type from query				*/
/*  _type	: KBType *	: Query field type			*/
/*  (returns)	: void		  :					*/


void	KBSummary::setFieldType
	(	KBType	*type
	)
{
	KBItem::setFieldType (type) ;
	sumFunc	= &KBSummary::sumUnknown ;

	if (type->getIType() == KB::ITFixed)
	{
		if	(summary.getValue() == "Total"  ) sumFunc = &KBSummary::sumSumInt    ;
		else if	(summary.getValue() == "Minimum") sumFunc = &KBSummary::sumMinInt    ;
		else if	(summary.getValue() == "Maximum") sumFunc = &KBSummary::sumMaxInt    ;
	}
	if (type->getIType() == KB::ITFloat)
	{
		if	(summary.getValue() == "Total"  ) sumFunc = &KBSummary::sumSumDouble ;
		else if	(summary.getValue() == "Minimum") sumFunc = &KBSummary::sumMinDouble ;
		else if	(summary.getValue() == "Maximum") sumFunc = &KBSummary::sumMaxDouble ;
	}
	if (sumFunc == &KBSummary::sumUnknown)
		KBError::EWarning
		(	"Summary field type error",
			"Invalid combination for summary and field type",
			__ERRLOCN
		)	;
}

/*  KBSummary								*/
/*  prepare	: Prepare item prior prior to display			*/
/*  (returns)	: void		:					*/

void	KBSummary::prepare ()
{
	KBObject::prepare () ;
	nVals	= 0 ;
}

/*  KBSummary								*/
/*  setValue	: Set value						*/
/*  qrow	: uint		  : Current query row			*/
/*  value	: const KBValue & : Value				*/
/*  (returns)	: bool		  : Success				*/

bool	KBSummary::setValue
	(	uint		,
		const KBValue	&value
	)
{
	KB::ScriptRC	eRC 	;
	bool		subs	;
	(this->*sumFunc) (expr.evaluate (value, eRC, subs)) ;

	switch (eRC)
	{
		case KB::ScriptInlineError :
			propertyDlg (expr.getValue()) ;
			return	false	   ;

		case KB::ScriptGlobalError :
			return	false	   ;

		default	:
			break	;
	}

	nVals  += 1  ;
	return	true ;
}

/*  KBSUmmary								*/
/*  getReportValue							*/
/*		: Get value for report writing				*/
/*  first	: bool		: First output flag			*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBSummary::getReportValue
	(	bool	
	)
{
	KBValue	value	;

	if (sumFunc != &KBSummary::sumUnknown)
		switch (type->getIType())
		{
			case KB::ITFixed :
				value	= iVal	;
				break	;

			case KB::ITFloat :
				value	= dVal	;
				break	;

			default	:
				value	= "#Error" ;
				break	;
		}
		else	value	= "#Error" ;

	
	if (reset.getBoolValue()) nVals = 0 ;
	return	value	;
}

#if	! __KB_RUNTIME
/*  KBSummary								*/
/*  propertyDlg	: Show property dialog					*/
/*  iniAttr	: cchar *	: Initial attribute			*/
/*  (returns)	: bool		: Success				*/

bool	KBSummary::propertyDlg
	(	cchar	*iniAttr
	)
{
	if (!::summaryPropDlg (this, "Summary", attribs, iniAttr))
		return false ;

	updateProps () ;
	return true    ;
}
#endif

NEWNODE(Summary, __TR("New &Summary"), KF_REPORT|KF_BLOCK|KF_FRAMER|KF_DATA)
