/***************************************************************************
    file	         : kb_accel.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qstring.h>
#include	<qstringlist.h>
#include	<qaccel.h>


static	int	decodePart
	(	const QString	&string
	)
{
	fprintf
	(	stderr,
		"decodePart: decode [%s]\n",
		(const char *)string
	)	;

	if (string == "meta" ) return Qt::META  ;
	if (string == "shift") return Qt::SHIFT ;
	if (string == "ctrl" ) return Qt::CTRL  ;
	if (string == "alt"  ) return Qt::ALT   ;

	if (string.left(4) == "key_")
	{
		if ((string.length() == 5) && string[4].isLetter())
			return	Qt::Key_A  + (string[4].latin1() - 'a') ;

		if ((string.length()  > 5) && (string[4].latin1() == 'f'))
			return	Qt::Key_F1 + (string.mid(5).toInt() - 1) ;
	}

	return	0 ;
}

QKeySequence
	stringToSequence
	(	const QString	&string
	)
{
	QStringList	bits	= QStringList::split(';', string) ;
	int		keys[4]	;

	keys[0]	= 0	;
	keys[1]	= 0	;
	keys[2]	= 0	;
	keys[3]	= 0	;

	for (uint bit = 0 ; (bit < 4) && (bit < bits.count()) ; bit += 1)
	{
		QStringList parts = QStringList::split('+', bits[bit]) ;

		for (uint part = 0 ; part < parts.count() ; part += 1)
			keys[bit] += decodePart (parts[part].lower()) ;
	}

	return	QKeySequence (keys[0], keys[1], keys[2], keys[3]) ;
}
