/***************************************************************************
    file	         : kb_copyquery.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_qryquery.h"
#include	"kb_select.h"

#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"

#include	"kb_param.h"

#include	"kb_copybase.h"
#include	"kb_copyquery.h"



/*  KBCopyQuery								*/
/*  KBCopyQuery	: Constructor for table copier				*/
/*  srce	: bool		: Source, else destination		*/
/*  location	: KBLocation &	: Database location			*/
/*  (returns)	: KBCopyQuery	:					*/

KBCopyQuery::KBCopyQuery
	(	bool		srce,
		KBLocation	&location
	)
	:
	m_srce	   (srce),
	m_location (location)
{
	m_qExec	 = false ;
	m_select = 0	 ;
}


/*  KBCopyQuery								*/
/*  ~KBCopyQuery: Destructor for table copier				*/
/*  (returns)	:		:					*/

KBCopyQuery::~KBCopyQuery ()
{
	DELOBJ	(m_select) ;
}

/*  KBCopyQuery								*/
/*  tag		: Get tag for XML output				*/
/*  (returns)	: cchar *	: Tag					*/

cchar	*KBCopyQuery::tag ()
{
	return	"query"	;
}

/*  KBCopyQuery								*/
/*  set		: Set copier from definition				*/
/*  copy	: QDomElement & : Definition parent			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

bool	KBCopyQuery::set
	(	QDomElement	&copy,
		KBError		&
	)
{
	QDomElement element	= copy.namedItem(tag()).toElement() ;
	if (element.isNull ()) return true ;

	reset	()	;

	setServer   (element.attribute ("server"  )) ;
	setQuery    (element.attribute ("query"   )) ;

	QDomNodeList	dFields	= element.elementsByTagName ("field") ;
	for (uint idx = 0 ; idx < dFields.length() ; idx += 1)
		m_fields.append (dFields.item(idx).toElement().attribute("name")) ;

	return	true	;
}

/*  KBCopyQuery								*/
/*  valid	: Check validity					*/
/*  error	: KBError &	: Error return				*/
/*  (returns)	: bool		: Valid					*/

bool	KBCopyQuery::valid
	(	KBError		&error
	)
{
	if (m_server.isEmpty())
	{
		error	= KBError
			  (	KBError::Error,
				TR("Server not set in query copier"),
				QString::null,
				__ERRLOCN
			  )	;
		return	false	;
	}
	if (m_query .isEmpty())
	{
		error	= KBError
			  (	KBError::Error,
				TR("Query not set in query copier"),
				QString::null,
				__ERRLOCN
			  )	;
		return	false	;
	}
	if (m_fields.count() == 0)
	{
		error	= KBError
			  (	KBError::Error,
				TR("No fields set in query copier"),
				QString::null,
				__ERRLOCN
			  )	;
		return	false	;
	}

	return	true	;
}

/*  KBCopyQuery								*/
/*  def		: Get table copy definition				*/
/*  copy	: QDomElement &	: Element to which to attach		*/
/*  (returns)	: void		:					*/

void	KBCopyQuery::def
	(	QDomElement	&copy
	)
{
	QDomElement	element	;

	copy   .appendChild  (element = copy.ownerDocument().createElement (tag())) ;

	element.setAttribute ("server",   m_server  ) ;
	element.setAttribute ("query",    m_query   ) ;

	for (uint idx = 0 ; idx < m_fields.count() ; idx += 1)
	{
		QDomElement	dField	;
		element.appendChild  (dField = element.ownerDocument().createElement ("field")) ;
		dField.setAttribute ("name", *m_fields.at(idx)) ;
	}
}


/*  KBCopyQuery								*/
/*  getColumnNames							*/
/*		: Get column names					*/
/*  names	: QStringList &	: List of column names			*/
/*  (returns)	: void		:					*/

void	KBCopyQuery::getColumnNames
	(	QStringList	&names
	)
{
	names	= m_fields ;
}

/*  KBCopyQuery								*/
/*  prepare	: Prepare for execution					*/
/*  paramDict	: const QDict<QString> &				*/
/*				: Paramater dictionary			*/
/*  other	: KBCopyBase *	: Other half of copier			*/
/*  (returns)	: bool		: Success				*/

bool	KBCopyQuery::prepare
	(	const QDict<QString>	&,
		KBCopyBase		*
	)
{
	/* Connect to the database server. If this fails then grab the	*/
	/* error and return false.					*/
	m_dbLink.disconnect () ;

	if (!m_dbLink.connect (m_location, m_server))
	{	m_lError = m_dbLink.lastError () ;
		return	 false	;
	}

	/* The strategy is to construct and load the KBQryQuery object,	*/
	/* then to extract from it the SQL select query (into a		*/
	/* KBSelect object). The fields are added, then the actual SQL	*/
	/* query can be constructed.					*/
	KBLocation	locn
			(	m_location.dbInfo,
				"query",
				m_server,
				m_query
			)	;

	KBDummyRoot	dummy	(locn) ;

	KBQryQuery *qry	 = new KBQryQuery (&dummy) ;

	if (!qry->loadQueryDef (locn))
	{
		m_lError = qry->lastError () ;
		return	 false	;
	}

	KBSelect select ;
	if (!qry->getSelect (0, select))
	{
		m_lError = qry->lastError () ;
		return	 false	;
	}

	for (uint idx1 = 0 ; idx1 < m_fields.count() ; idx1 += 1)
		select.appendExpr (*m_fields.at(idx1)) ;

	m_select = m_dbLink.qrySelect (true, select.getQueryText (&m_dbLink)) ;
	if (m_select == 0)
	{
		m_lError = m_dbLink.lastError () ;
		return	 false	;
	}

	/* Ready to go. Reset the row counter and return success.	*/
	m_sRow	= 0	;
	return	true	;
}

/*  KBCopyQuery								*/
/*  getNumCols	: Get number of columns in copy				*/
/*  (returns)	: int		: Number of columns			*/

int	KBCopyQuery::getNumCols ()
{
	return	m_fields.count () ;
}

/*  KBCopyQuery								*/
/*  getRow	: Get next row						*/
/*  values	: KBValue *	: Value vector				*/
/*  nCols	: uint		: Number of columns available		*/
/*  ok		: bool &	: Execute OK				*/
/*  (returns)	: int		: Actual number of columns		*/

int	KBCopyQuery::getRow
	(	KBValue		*values,
		uint		,
		bool		&ok
	)
{
	/* Check that this is a source copier, if not then there is an	*/
	/* implementation error.					*/
	if (!m_srce)
	{
		m_lError = KBError
			   (	KBError::Fault,
				TR("Attempt to fetch row from destination copier"),
				QString::null,
				__ERRLOCN
			   )	;
		ok	= false	;
		return	-1	;
	}

	/* See if the select query has been executed, if not then do so	*/
	/* now and reset the current row number. If there is an error	*/
	/* then return with "ok" set false (error occurred) and a false	*/
	/* result (no row available).					*/
	if (!m_qExec)
	{
		if (!m_select->execute (0, 0))
		{
			m_lError = m_select->lastError () ;
			ok	 = false ;
			return	 -1 ;
		}

		m_qExec	= true	;
		m_sRow	= 0	;
	}

	/* If the row number has exceeded then number of rows available	*/
	/* then all rows have been retrieved. The "ok" value is set	*/
	/* true as there is no error, but return false to indicate the	*/
	/* end of the data.						*/
	if (!m_select->rowExists (m_sRow))
	{
		ok	= true	;
		return	-1	;
	}

	/* Copy the next row, increment the row count, and return with	*/
	/* both "ok" set true (no error) and true to indicate that	*/
	/* there is a row of data available.				*/
	for (uint sCol = 0 ; sCol < m_select->getNumFields() ; sCol += 1)
		values[sCol] = m_select->getField (m_sRow, sCol) ;

	m_sRow += 1	;
	ok	= true	;
	return	m_select->getNumFields() ;
}

/*  KBCopyQuery								*/
/*  putRow	: Put a row of data					*/
/*  values	: KBValue *	: Value vector				*/
/*  aCols	: uint		: Actual number of columns		*/
/*  (returns)	: bool		: Success				*/

bool	KBCopyQuery::putRow
	(	KBValue		*,
		uint		
	)
{
	m_lError = KBError
		   (	KBError::Fault,
			TR("Attempt to insert row into query copier"),
			QString::null,
			__ERRLOCN
		   )	;
	return	false	;
}

/*  KBCopyQuery								*/
/*  finish	: Finish execution					*/
/*  report	: QString &	: Completion report			*/
/*  (returns)	: bool		: Success				*/

bool	KBCopyQuery::finish
	(	QString		&
	)
{
	m_dbLink.disconnect () ;
	return	true	 ;
}

/*  KBCopyQuery								*/
/*  (returns)	: void		:					*/

void	KBCopyQuery::reset ()
{
	m_server= QString::null ;
	m_query	= QString::null ;
	m_qExec	= false		;

	m_fields.clear 	    ()	;
	m_dbLink.disconnect ()	;
}

/*  KBCopyQuery								*/
/*  setServer	: Set server name					*/
/*  server	: const QString & : Server name				*/
/*  (returns)	: void		  :					*/

void	KBCopyQuery::setServer
	(	const QString	&server
	)
{
	m_server = server	;
}

/*  KBCopyQuery								*/
/*  setQuery	: Set query name					*/
/*  query	: const QString & : Query name				*/
/*  (returns)	: void		  :					*/

void	KBCopyQuery::setQuery
	(	const QString	&query
	)
{
	m_query	= query	;
}

/*  KBCopyQuery								*/
/*  addField	: Add field name					*/
/*  field	: const QString & : Field name				*/
/*  (returns)	: void		  :					*/

void	KBCopyQuery::addField
	(	const QString	&field
	)
{
	m_fields.append (field)	;
}

