/***************************************************************************
    file	         : kb_formblock.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FORMBLOCK_H
#define	_KB_FORMBLOCK_H

#include	"libkbase_exports.h"

#include	"kb_block.h"
#include	"kb_navigator.h"

class KBBlockEvents	;

/*  KBFormBlock								*/
/*  -----------								*/
/*  This class implements the block object when embedded in a form.	*/

class LIBKBASE_API	KBFormBlock : public KBBlock, public KBNavigator
{
	Q_OBJECT

	KBAttrBool		m_sloppy    ;	/* Sloppy row focus	*/
	KBAttrBool		m_blkrdonly ;	/* Whole block readonly	*/
	KBAttrBool		m_tabsWrap  ;	/* Tabs wrap round	*/
	KBAttrUInt		m_locking   ;	/* Record lockng option	*/

	KBItem			*m_curItem  ;	/* Current focus item	*/
	bool			m_inQuery   ;	/* In search		*/
	bool			m_dChanged  ;	/* Data has changed	*/

	virtual	KBPopupMenu	*makeNewPopup	(bool, QRect)		;
	void			displayData	(bool, uint,   uint) 	;
	void			clearFields	(uint, bool = false)	;
	bool			checkChange	(bool, bool &)		;
	bool			checkChange	(bool)			;
	bool			doSyncAll	(KBValue *)		;
	bool			doSyncRow	(KBValue *, uint)	;

	void			focusMovesRow	(uint)			;
	void			focusMovesItem	(KBItem *, QFocusEvent::Reason) ;

public	:

	KBFormBlock (KBNode   *, const QDict<QString> &, cchar * = "KBFormBlock", bool * = 0) ;
	KBFormBlock (KBObject *, const QRect &, BlkType, bool  &, cchar * = "KBFormBlock") ;
	KBFormBlock (KBNode   *, KBFormBlock *) ;
virtual~KBFormBlock () ;

	virtual	KBFormBlock	*isFormBlock	() { return this ; }
	virtual	KBNavigator	*isNavigator	() { return this ; }

	virtual	void		remChild	(KBNode *)	 ;
	virtual	void		showAs		(KB::ShowAs)	 ;
	virtual	bool		resize		(int, int) 	 ;
	virtual	bool		blockSetup	() 		 ;
	virtual bool		requery		()		 ;

	void			markChanged	()		 ;
	void			enterBlock	(bool,     uint) ;
	void			focusInEvent	(KBItem *, uint, QFocusEvent::Reason) ;
	bool			moveFocusOK	(KBItem *, uint) ;
	void			moveFocusTo	(KBItem *)	 ;
	bool			focusOutOK	(bool) ;
	virtual	uint		rowsInBlock	()     ;

	virtual	KBNode		*replicate	(KBNode *) ;
	bool			doOperation	(KB::Action, uint, KBTabOrderList * = 0) ;
	bool			doAction	(KB::Action,       KBTabOrderList * = 0) ;
	bool			gotoQRow	(uint) ;
	bool			insertRow	(uint) ;
	bool			deleteRow	(uint) ;
	bool			showData	(bool = false, bool = true) ;

	void			setRowMarked	(uint, KB::MarkOp) ;
	bool			getRowMarked	(uint) ;

	virtual	KBValue		getValue	(uint) ;
	virtual	bool		setValue	(uint, const KBValue &) ;
	virtual	KBValue		*getBlockVal	()     ;
	void			scrollToRow	(uint) ;
	void			scrollBy	( int) ;
	void			changeSizes	()     ;

	void			sortByColumn	(KBItem *, bool) ;

	void			dataChanged	(uint) ;
	bool			startUpdate	(uint) ;
	bool			endUpdate	(bool) ;

	void			getResults	(const QString &, QDict<QString> &) ;

	inline	bool		isInQuery	() { return m_inQuery ; }
	inline	KBItem		*getCurItem	() { return m_curItem ; }

	inline	bool		isBlkReadOnly	()
	{
		return	m_blkrdonly.getBoolValue() ;
	}
	inline	bool		tabsWrap	()
	{
		return	m_tabsWrap .getBoolValue() ;
	}

#if	! __KB_RUNTIME
	virtual bool		playerAdd	(const QStringList &, KBError &) ;
#endif

public	slots :

	virtual void		docPropDlg	() ;
	virtual KBNode		*newNode	(int) ;

	void			newNullBlock	() ;
	void			newTableBlock	() ;
	void			newSQLBlock	() ;
	void			newQueryBlock	() ;
	void			newContainer	() ;
	void			newViaWizard	() ;

	void			newTabOrder	() ;
}	;

#endif	// _KB_FORMBLOCK_H
