/***************************************************************************
    file	         : kb_hidden.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qcursor.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_sizer.h"
#include	"kb_ctrl.h"
#include	"kb_node.h"
#include	"kb_object.h"
#include	"kb_item.h"
#include	"kb_block.h"
#include	"kb_hidden.h"
#include	"kb_nodereg.h"


/*  KBHidden								*/
/*  KBHidden	: Constructor for hidden form field			*/
/*  parent	: KBNode *	: Parent node				*/
/*  aList	: const QDict<QString> &				*/
/*				: List of attributes			*/
/*		: bool *	:					*/
/*  (returns)	: KBNode	:					*/

KBHidden::KBHidden
	(	KBNode			*parent,
		const QDict<QString>	&aList,
		bool			*
	)
	:
	KBItem	(parent, "KBHidden",	"expr",  aList)
{
	values	= 0 ;
	tabOrd.setValue (0) ;
	init	()  ;
}

/*  KBHidden								*/
/*  KBHidden	: Constructor for hidden form field			*/
/*  parent	: KBObject *	: Parent node				*/
/*  name	: const QString&: Control name				*/
/*  expr	: const QString&: Expression				*/
/*  (returns)	: KBHidden	:					*/

KBHidden::KBHidden
	(	KBObject	*parent,
		bool		&ok
	)
	:
	KBItem	(parent, "KBHidden",	QRect(), "expr", "", 0)
{
	tabOrd.setValue (0) ;
	values = 0 ;
	init	() ;

#if	! __KB_RUNTIME
	if (!KBNode::propertyDlg ("Hidden"))
	{	ok	= false	;
		return	;
	}
#endif
	ok	= true	;
}

/*  KBHidden								*/
/*  KBHidden	: Constructor for hidden form field			*/
/*  _parent	: KBNode *	: Parent node				*/
/*  _hidden	: KBHidden *	: Extant hidden field			*/
/*  (returns)	: KBNode	:					*/

KBHidden::KBHidden
	(	KBNode		*_parent,
		KBHidden	*_hidden
	)
	:
	KBItem	(_parent, "expr", _hidden)
{
	tabOrd.setValue (0) ;
	values = 0  ;
	init	()  ;
}

/*  KBHidden								*/
/*  ~KBHidden	: Destructor for simple form field			*/
/*  (returns)	:		:					*/

KBHidden::~KBHidden ()
{
	if (values != 0) delete []values ;
}

/*  KBHidden								*/
/*  init	: Initialise						*/
/*  (returns)	: void		:					*/

void	KBHidden::init ()
{
	/* We detach all the attributes that are not relevent, so that	*/
	/* they will not show up in the properties dialog.		*/
	attribs.remove (getAttr("x")) ;
	attribs.remove (getAttr("y")) ;
	attribs.remove (getAttr("w")) ;
	attribs.remove (getAttr("h")) ;
	attribs.remove (getAttr("xmode")) ;
	attribs.remove (getAttr("ymode")) ;

	attribs.remove (&tabOrd ) ;
	attribs.remove (&defVal ) ;
	attribs.remove (&rdonly ) ;
	attribs.remove (&onEnter) ;
	attribs.remove (&onLeave) ;
}

/*  KBHidden								*/
/*  calcNumRows	: Calculate number of rows which can be show		*/
/*  bw		: uint		: Block display width			*/
/*  bh		: uint		: Block display height			*/
/*  dx		: int		: Control X-spacing			*/
/*  dy		: int		: Control Y-spacing			*/
/*  (returns)	: uint		: Number of rows that can be displayed	*/

uint	KBHidden::calcNumRows
	(	uint	,
		uint	,
		int	,
		int
	)
{
	/* There is no limit since hidden controls do not actually	*/
	/* appear on the display.					*/
	return	999	;
}

/*  KBHidden								*/
/*  dx		: int		: Control X-spacing			*/
/*  dy		: int		: Control Y-spacing			*/
/*  limit	: uint		: Upper limit on number of rows		*/
/*  (returns)	: uint		: Number of rows that can be displayed	*/

uint	KBHidden::calcNumRows
	(	int	,
		int	,
		uint	limit
	)
{
	return	limit	;
}

/*  KBHidden								*/
/*  buildCtrls	: Build notional controls					*/
/*  numrows	: uint		: Number of rows to be displayed	*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBHidden::buildCtrls
	(	uint		numrows,
		int		dx,
		int		dy
	)
{
//	fprintf	(stderr, "KBHidden::buildCtrls: numrows=%d\n", numrows) ;

	if (values == 0)
	{
		nRows	= numrows ;
		values	= new KBValue[numrows] ;
		return	;
	}

	extendCtrls (numrows, dx, dy) ;
}

/*  KBHidden								*/
/*  extendCtrls	: Extend (or decrease) the number of controls		*/
/*  numrows	: uint		: New number of rows			*/
/*  dx		: int		: X offset between rows			*/
/*  dy		: int		: Y offset between rows			*/
/*  (returns)	: void		:					*/

void	KBHidden::extendCtrls
	(	uint	numrows,
		int	,
		int	
	)
{
//	fprintf	(stderr, "KBHidden::extendCtrls: numrows=%d\n", numrows) ;

	if ((values != 0) && (numrows != nRows))
	{
		KBValue	*newvals = new KBValue[numrows]  ;
		uint	copyto   = nRows < numrows ? nRows : numrows ;

		for (uint idx = 0 ; idx < copyto ; idx += 1)
			newvals[idx] = values[idx] ;

		delete	[] values	;
		values	=  newvals	;
		nRows	=  numrows	;
	}
}

/*  KBItem								*/
/*  valuesAtQRow: Get value pair at specified row			*/
/*  qrow	: uint		: Specific row				*/
/*  (returns)	: KBValue *	: Value or none				*/

KBValue	*KBHidden::valueAtQRow
	(	uint	qrow
	)
{
	uint	curDRow  = getBlock()->getCurDRow    () ;
//	uint	dispRows = getBlock()->getDisplayRows() ;
//
//	if ((qrow >= curDRow) && (qrow < curDRow + dispRows))
//		return	&values[qrow - curDRow] ;

	if (values != 0)
		if ((qrow >= curDRow) && (qrow < curDRow + nRows))
			return	&values[qrow - curDRow] ;

	setError
	(	KBError::Error,
		TR("Row in query not currently displayed"),
		QString	(TR("Field %1, query row %2: showing %3 ... %4"))
			.arg(name.getValue())
			.arg(qrow)
			.arg(curDRow)
//			.arg(curDRow + dispRows - 1),
			.arg(curDRow + nRows    - 1),
		__ERRLOCN
	)	;
	return	0	;
}

/*  KBHidden								*/
/*  getValue	: Get value						*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: KBValue	: Value					*/

KBValue	KBHidden::getValue
	(	uint	qrow
	)
{
	KBValue	*value	= valueAtQRow (qrow)	;
	return	value == 0 ? KBValue() : *value ;
}

/*  KBHidden								*/
/*  setValue	: Set value display row					*/
/*  qrow	: uint		 : Query row				*/
/*  value	: const KBValue &: Value to set				*/
/*  (returns)	: bool		 : Success				*/

bool	KBHidden::setValue
	(	uint		qrow,
		const KBValue	&value
	)
{
	KB::ScriptRC	eRC	;
	bool		subs	;
	KBValue		v	= expr.evaluate (value, eRC, subs) ;

	switch (eRC)
	{
		case KB::ScriptInlineError :
#if	! __KB_RUNTIME
			getParent()->isObject()->propertyDlg ("hidden") ;
#endif
			return	false	   ;

		case KB::ScriptGlobalError :
			return	false	   ;

		default	:
			break	;
	}

	KBValue	*vp	= valueAtQRow (qrow) ;
	if (vp != 0) *vp = v ;
	return	true	;
}

/*  KBHidden								*/
/*  clearValue	: Clear value for specified query and display row	*/
/*  qrow	: uint		: Starting row in query			*/
/*  query	: bool		: Clearing for query			*/
/*  (returns)	: void		:					*/

void	KBHidden::clearValue
	(	uint	qrow,
		bool
	)
{
	KBValue	*value = valueAtQRow (qrow) ;
	if (value != 0) *value = KBValue("", &_kbString) ;
}

/*  KBHidden								*/
/*  changed	: See if item has changed				*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: bool		: Item changed				*/

bool	KBHidden::changed
	(	uint	qrow
	)
{
	KBValue	*value = valueAtQRow (qrow) ;
	return	value == 0 ? false : *value != getIniValue (qrow) ;
}

/*  KBHidden								*/
/*  isValid	: Test if value is valid to be saved			*/
/*  qrow	: uint		: Query row				*/
/*  alowNull	: bool		: Ignore not-null check			*/
/*  (returns)	: bool		: Value can be saved			*/

bool	KBHidden::isValid
	(	uint	qrow,
		bool
	)
{
	return	valueAtQRow (qrow) != 0 ;
}

/*  KBHidden								*/
/*  isEmpty	: See if value is empty					*/
/*  qrow	: uint		: Query row				*/
/*  (returns)	: bool		: Empty					*/

bool	KBHidden::isEmpty
	(	uint	qrow
	)
{
	KBValue	*value	= valueAtQRow (qrow) ;
	return	value == 0 ? true : value->getRawText().isEmpty() ;
}

/*  KBHidden								*/
/*  replicate	: Replicate this hidden field				*/
/*  _parent	: KBNode *	: Parent of replicant			*/
/*  (returns)	: KBNode *	: New hidden node			*/

KBNode	*KBHidden::replicate
	(	KBNode	*_parent
	)
{
	return	new KBHidden (_parent, this) ;
}

#if	! __KB_RUNTIME
bool	KBHidden::propertyDlg ()
{
	return	KBNode::propertyDlg ("hidden") ;
}
#endif


NEWNODE(Hidden, (cchar *)0, KF_FORM)
