/***************************************************************************
    file	         : kb_item.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FORMITEM_H
#define	_KB_FORMITEM_H

#include	"libkbase_exports.h"

#include	"kb_object.h"
#include	"kb_qryidx.h"
#include	"kb_attrexpr.h"


/*  KBItem								*/
/*  ----------								*/
/*  This class is used for form elements which are related to values	*/
/*  returned by queries, and hence have an expression (whicn might just	*/
/*  be a column name) and a query column index. It is this class that	*/
/*  the KBSQLQuery class accesses.					*/


class LIBKBASE_API	KBItem : public KBObject
{
	Q_OBJECT

	KBNodeMonitor	*ctrlMon	;	/* Monitor display	*/

	KBTable		*m_table	;	/* Associated table	*/
	uint		m_flags		;	/* KBFieldSpec flags	*/
	QString		m_defval  	;	/* RDBMS-level default	*/

	int		m_isUpdateVal	;

protected :

	KBAttrExpr	expr		;	/* Query expression	*/
	KBAttrBool	rdonly		;	/* Value is read-only	*/
	KBAttrBool	noupdate	;	/* Do not update item	*/
	KBAttrUInt	tabOrd  	;	/* Tab ordering		*/
	KBAttrExpr	defVal		;	/* Default value	*/
	KBAttrStr	errtext		;	/* Error message text	*/

	KBEvent		onEnter		;	/* Focus enters field	*/
	KBEvent		onLeave		;	/* Focus leaves field	*/
	KBEvent		onSet		;	/* Field value is set	*/

	KBQryIdx	qryIdx		;	/* Query column index	*/
	bool		needed		;	/* Query needs column	*/

	KBType		*type		;	/* Column type		*/

	uint		nCtrls		;	/* Child controls count	*/
	KBControl	**ctrls		;	/* Child controls	*/

	KBValue		curVal		;	/* Current row value	*/
	bool		fSubs		;	/* Value substitution	*/

	bool		m_allEnabled	;	/* Global enable	*/
	bool		m_allVisible	;	/* Global visible	*/


	void			setupCtrls	(uint, int, int)  ;

	virtual void		setPalette 	() ;
	virtual void		setFont		() ;
	KBControl		*&ctrlAtQRow	(uint) ;
	virtual	void		setMonitor	(KBNodeMonitor *) ;
	virtual	bool		isMorphing	()		  ;
	virtual	void		prepare		()		  ;
	virtual	void		prepareCtrls	(uint, uint)	  ;

	void			userChange	(uint)		  ;

public	:

	KBItem	(KBNode   *, cchar *, cchar *, const QDict<QString> &) ;
	KBItem	(KBObject *, cchar *, const QRect &, cchar *, cchar *, uint) ;
	KBItem	(KBNode   *, cchar *, KBItem *) ;
	virtual ~KBItem () ;

	virtual	KBItem  	*isItem () { return this  ; }

	virtual	void		updateProps	()			;
	virtual	void		buildCtrls	(uint, int, int) 	;
	virtual	KBControl	*makeCtrl	(uint)			;
	virtual	void		ctrlGone	(KBControl *)		;

	virtual	void		move		(int, int)		;
	virtual	bool		resize		(int, int)		;
	virtual	void		redraw		()			;

	virtual	bool		ctrlGeometry	(uint, QRect  &)	;
	void			reposition	()			;
	virtual void		extendCtrls	(uint, int, int)	;
	virtual	void		giveFocus    	(uint)			;

	bool			startUpdate	(uint)		  	;
	virtual	bool		isUpdateVal	() ;
	virtual	void		setFieldType	(KBType *) ;
	virtual	KBValue::VTrans	getVTrans	() ;

	/* NOTE:							*/
	/* In the following methods which refer to data values, the	*/
	/* first unsigned-int argument is the associated query row	*/
	/* number, ie., the row number in the query which returned the	*/
	/* original value.						*/
	virtual	void		setData		(uint, void  *) ;
	virtual	bool		setValue	(uint, const KBValue &) ;
	virtual	KBValue		getValue	(uint) ;
	virtual	KBValue		getRowValue	(uint) ;
	virtual	KBValue		getIniValue	(uint) ;
	virtual	bool		isEmpty		(uint) ;
	virtual void		clearValue	(uint, bool) ;
	virtual	bool		isValid		(uint, bool) ;
	virtual	bool		changed		(uint) ;

	virtual	QString		getOrderValue	(const KBValue &) ;
	virtual	KB::IType	getOrderType	()     ;

	virtual	void		hideBelow	(uint) ;
	virtual	void		clearBelow	(uint) ;

	virtual	void		setTabOrder	(int ) ;
	virtual	int		getTabOrder	()     ;

	virtual	void		setMarked	(uint, bool) ;
	virtual	void		setEnabled	(uint, bool) ;
	virtual	void		setVisible	(uint, bool) ;
	virtual bool		isEnabled	(uint) ;
	virtual bool		isVisible	(uint) ;

	virtual	void		setAllEnabled	(bool) ;
	virtual	void		setAllVisible	(bool) ;

	virtual	void		showAs		(KB::ShowAs) ;

	QString			getExpr		() ;
	bool			isReadOnly	() ;

	inline	uint		getQueryIdx	()	 	{ return qryIdx.qryIdx() ; }
	inline	uint		getQueryLvl	()	 	{ return qryIdx.qryLvl() ; }

	inline	void		setQueryIdx	(KBQryIdx qi)	{ qryIdx   =  qi ; } 

	inline	KBType		*getFieldType	()	 	{ return type	 ; }
	inline	void		setNeeded	(bool v) 	{ needed = v	 ; }

	inline	void		setTable	(KBTable *t)	{ m_table  =   t ; }
	inline	KBTable		*getTable 	()		{ return m_table ; }

	inline	void		setFlags	(uint f )	{ m_flags  =   f ; }
	inline	void		addFlags	(uint f )	{ m_flags |=   f ; }
	inline	void		remFlags	(uint f )	{ m_flags &=  ~f ; }
	inline	uint		flags		()		{ return m_flags ; }

	inline	void		setDefVal	(QString v)	{ m_defval =   v ; }
	inline	const QString	&getDefVal	()		{ return m_defval; }

	virtual	bool		moveFocusOK	(uint) ;
	virtual	void		focusInEvent	(uint, QFocusEvent::Reason) ;
	virtual	void		reMorphItem	(uint) ;
	virtual	bool		keyStroke	(QKeyEvent   *) ;

	virtual	void		doEnter		(uint) ;
	virtual	bool		doLeave		(uint) ;

	virtual	KBValue		getReportValue	(bool) ;
	virtual	bool		write		(KBWriter *, QPoint, bool, int &) ;

#if	! __KB_EMBEDDED
	virtual	QVariant	property	(uint, cchar *)		;
	virtual	bool		setProperty	(uint, cchar *, const QVariant &) ;
#endif

	virtual	void		repaintMorph	(QPainter *, uint) ;
	virtual	void		repaintMorph	(QPainter *, const QRect &) ;
	virtual	bool		mouseClickHit	(const QPoint &) ;


	virtual	void		doSearch	()	;
	virtual	QString		getSearchText	(uint)	;

	inline	QString		getErrText ()
	{
		return	errtext.getValue   () ;
	}

	friend	class	KBForm	;
}	;


#endif	// _KB_FORMITEM_H
