/***************************************************************************
    file	         : kb_paramdlg.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PARAMDLG_H
#define	_KB_PARAMDLG_H

#if	! __KB_RUNTIME


#include	<qlist.h>
#include	<qwidget.h>
#include	<qlayout.h>
#include	<qlabel.h>
#include	<qpushbutton.h>
#include	<qlistview.h>
#include	<qcheckbox.h>

#include	"kb_param.h"
#include	"kb_dialog.h"
#include	"kb_paramsetdlg.h"
#include	"libkbase_exports.h"

#include	"tk_lineedit.h"


/*  KBParamItem								*/
/*  -----------								*/
/*  This is a wrapper round a list view item, used to store a pointer	*/
/*  at an associated KBParam object.					*/

class LIBKBASE_API	KBParamItem : public QListViewItem
{
	KBParam		*m_param	;
	QString		m_format	;
	bool		m_prompt	;

public	:

	KBParamItem (QListView *, KBParam       *) ;
	KBParamItem (QListView *, const QString &, const QString &, const QString &, const QString &, bool) ;
        virtual ~KBParamItem () ;

	inline	KBParam 	*getParam	() { return m_param 	; }
	inline	QString		getFormat	() { return m_format	; }
	inline	bool		getPrompt	() { return m_prompt	; }

	void			fixUp		(KBNode *) ;
}	;

/*  KBParamDlg								*/
/*  ----------								*/
/*  This class is used as a component in the form and report properties	*/
/*  dialogs to handle editing of parameters.				*/

class LIBKBASE_API	KBParamDlg : public QWidget
{
	Q_OBJECT

	KBNode		*m_node		;
	QVBoxLayout	m_layMain	;
	QGridLayout	m_laySettings	;
	QLabel		m_lName		;
	QLabel		m_lDefval	;
	QLabel		m_lLegend	;
	QLabel		m_lFormat	;
	QLabel		m_lPrompt	;
	TKLineEdit	m_eName		;
	TKLineEdit	m_eDefval	;
	TKLineEdit	m_eLegend	;
	TKLineEdit	m_eFormat	;
	QPushButton	m_bFormat	;
	QCheckBox	m_ePrompt	;
	QPushButton	m_bAdd		;
	QPushButton	m_bRemove	;
	QPushButton	m_bEdit		;
	QListView	m_lvParams	;

	QList<KBParam>	m_dropped	;
	KBParamItem	*m_curItem	;

	void		init		() ;

protected slots :

	void		clickAdd	() ;
	void		clickRemove	() ;
	void		clickEdit	() ;
	void		clickFormat	() ;
	void		selectionChanged(QListViewItem *) ;

public	:

	KBParamDlg	(QWidget *, KBNode *, QList<KBParam> &) ;
	KBParamDlg	(QWidget *, const QDict<KBParamSet>  &) ;

	void		getValues	(QDict<KBParamSet>   &) ;
	void		fixUp		() ;
	QString		getText		() ;
}	;


/*  KBParamDesignDlg							*/
/*  ---------------							*/
/*  Wrapper around KBParamDlg to provide a stand-alone parameter setup	*/
/*  dialog.								*/

class LIBKBASE_API	KBParamDesignDlg : public _KBDialog
{
	Q_OBJECT

	KBParamDlg	m_paramDlg	;
	QPushButton	m_bOK		;
	QPushButton	m_bCancel	;
	QVBoxLayout	*m_layMain	;
	QHBoxLayout	*m_layButton	;

protected slots :

	void		clickOK	    ()	;
	void		clickCancel ()	;

public	:

	KBParamDesignDlg  (const QDict<KBParamSet> &) ;

	inline	void	getValues
		(	QDict<KBParamSet>	&values
		)
	{
		m_paramDlg.getValues (values) ;
	}	
}	;


#endif
#endif	// _KB_PARAMDLG_H
